<?php

namespace Modules\Dummy\Database\Seeders\Modules;

use Illuminate\Database\Seeder;

use Modules\Dummy\Database\Seeders\Modules\{
    MenuBuilder\MenuBuilderDatabaseSeeder,
    Newsletter\NewsletterDatabaseSeeder,
    OpenAI\OpenAIDatabaseSeeder,
    Blog\BlogDatabaseSeeder,
    CMS\CMSDatabaseSeeder,
    Coupon\CouponDatabaseSeeder,
    FAQ\FAQDatabaseSeeder,
    Gateway\GatewayDatabaseSeeder,
    Geolocale\GeoLocaleDatabaseSeeder,
    MediaManager\MediaManagerDatabaseSeeder,
    Subscription\SubscriptionDatabaseSeeder,
    Reviews\ReviewsDatabaseSeeder,
    Ticket\TicketDatabaseSeeder,
    Report\ReportDatabaseSeeder,
    Upgrader\UpgraderDatabaseSeeder,
    ElevenLabs\ElevenLabsDatabaseSeeder,
    FalAi\FalAiDatabaseSeeder,
    Pebblely\PebblelyDatabaseSeeder,
    Gemini\GeminiDatabaseSeeder
};

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $this->call([
            MenuBuilderDatabaseSeeder::class,
            NewsletterDatabaseSeeder::class,
            OpenAIDatabaseSeeder::class,
            BlogDatabaseSeeder::class,
            CMSDatabaseSeeder::class,
            CouponDatabaseSeeder::class,
            GatewayDatabaseSeeder::class,
            GeoLocaleDatabaseSeeder::class,
            MediaManagerDatabaseSeeder::class,
            TicketDatabaseSeeder::class,
            ReviewsDatabaseSeeder::class,
            SubscriptionDatabaseSeeder::class,
            FAQDatabaseSeeder::class,
            ReportDatabaseSeeder::class,
            UpgraderDatabaseSeeder::class,
            ElevenLabsDatabaseSeeder::class,
            FalAiDatabaseSeeder::class,
            PebblelyDatabaseSeeder::class,
            GeminiDatabaseSeeder::class
        ]);
    }
}
