<?php

namespace Modules\Dummy\Database\Seeders\Modules\Geolocale;

use Illuminate\Database\Seeder;

class GeoLocaleCountriesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('geolocale_countries')->truncate();
        
        \DB::table('geolocale_countries')->insert(array (
            0 => 
            array (
                'id' => 1,
                'continent_id' => 3,
                'name' => 'Cameroon',
                'full_name' => 'the Republic of Cameroon',
                'capital' => 'Yaoundé',
                'code' => 'cm',
                'code_alpha3' => 'cmr',
                'code_numeric' => 120,
                'emoji' => '🇨🇲',
                'has_division' => 1,
                'currency_code' => 'XAF',
                'currency_name' => 'CFA Franc BEAC',
                'tld' => '.cm',
                'callingcode' => '237',
            ),
            1 => 
            array (
                'id' => 2,
                'continent_id' => 3,
                'name' => 'Benin',
                'full_name' => 'the Republic of Benin ',
                'capital' => 'Porto-Novo',
                'code' => 'bj',
                'code_alpha3' => 'ben',
                'code_numeric' => 204,
                'emoji' => '🇧🇯',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.bj',
                'callingcode' => '229',
            ),
            2 => 
            array (
                'id' => 3,
                'continent_id' => 3,
                'name' => 'Madagascar',
                'full_name' => 'the Republic of Madagascar ',
                'capital' => 'Antananarivo',
                'code' => 'mg',
                'code_alpha3' => 'mdg',
                'code_numeric' => 450,
                'emoji' => '🇲🇬',
                'has_division' => 0,
                'currency_code' => 'MGA',
                'currency_name' => 'Malagasy Ariary',
                'tld' => '.mg',
                'callingcode' => '261',
            ),
            3 => 
            array (
                'id' => 4,
                'continent_id' => 3,
                'name' => 'Rwanda',
                'full_name' => 'the Republic of Rwanda',
                'capital' => 'Kigali',
                'code' => 'rw',
                'code_alpha3' => 'rwa',
                'code_numeric' => 646,
                'emoji' => '🇷🇼',
                'has_division' => 0,
                'currency_code' => 'RWF',
                'currency_name' => 'Rwanda Franc',
                'tld' => '.rw',
                'callingcode' => '250',
            ),
            4 => 
            array (
                'id' => 5,
                'continent_id' => 3,
                'name' => 'Seychelles',
                'full_name' => 'the Republic of Seychelles',
                'capital' => 'Victoria',
                'code' => 'sc',
                'code_alpha3' => 'syc',
                'code_numeric' => 690,
                'emoji' => '🇸🇨',
                'has_division' => 0,
                'currency_code' => 'SCR',
                'currency_name' => 'Seychelles Rupee',
                'tld' => '.sc',
                'callingcode' => '248',
            ),
            5 => 
            array (
                'id' => 6,
                'continent_id' => 3,
                'name' => 'Cote d’Ivoire',
                'full_name' => 'the Republic of Cote d’Ivoire',
                'capital' => 'Yamoussoukro',
                'code' => 'ci',
                'code_alpha3' => 'civ',
                'code_numeric' => 384,
                'emoji' => '🇨🇮',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.ci',
                'callingcode' => '225',
            ),
            6 => 
            array (
                'id' => 7,
                'continent_id' => 3,
                'name' => 'Egypt',
                'full_name' => 'the Arab Republic of Egypt ',
                'capital' => 'Cairo',
                'code' => 'eg',
                'code_alpha3' => 'egy',
                'code_numeric' => 818,
                'emoji' => '🇪🇬',
                'has_division' => 0,
                'currency_code' => 'EGP',
                'currency_name' => 'Egyptian Pound',
                'tld' => '.eg',
                'callingcode' => '20',
            ),
            7 => 
            array (
                'id' => 8,
                'continent_id' => 3,
                'name' => 'Mauritius',
                'full_name' => 'the Republic of Mauritius',
                'capital' => 'Port Louis',
                'code' => 'mu',
                'code_alpha3' => 'mus',
                'code_numeric' => 480,
                'emoji' => '🇲🇺',
                'has_division' => 0,
                'currency_code' => 'MUR',
                'currency_name' => 'Mauritius Rupee',
                'tld' => '.mu',
                'callingcode' => '230',
            ),
            8 => 
            array (
                'id' => 9,
                'continent_id' => 3,
                'name' => 'Burkina Faso',
                'full_name' => 'Burkina Faso',
                'capital' => 'Ouagadougou',
                'code' => 'bf',
                'code_alpha3' => 'bfa',
                'code_numeric' => 854,
                'emoji' => '🇧🇫',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.bf',
                'callingcode' => '226',
            ),
            9 => 
            array (
                'id' => 10,
                'continent_id' => 3,
                'name' => 'Eritrea',
                'full_name' => 'the Commonwealth of Eritrea',
                'capital' => 'Asmara',
                'code' => 'er',
                'code_alpha3' => 'eri',
                'code_numeric' => 232,
                'emoji' => '🇪🇷',
                'has_division' => 0,
                'currency_code' => 'ERN',
                'currency_name' => 'Nakfa',
                'tld' => '.er',
                'callingcode' => '291',
            ),
            10 => 
            array (
                'id' => 11,
                'continent_id' => 3,
                'name' => 'Sao Tome and Principe',
                'full_name' => 'the Democratic Republic Sao Tome and Principe',
                'capital' => 'São Tomé',
                'code' => 'st',
                'code_alpha3' => 'stp',
                'code_numeric' => 678,
                'emoji' => '🇸🇹',
                'has_division' => 0,
                'currency_code' => 'STD',
                'currency_name' => 'Dobra',
                'tld' => '.st',
                'callingcode' => '239',
            ),
            11 => 
            array (
                'id' => 12,
                'continent_id' => 3,
                'name' => 'Angola',
                'full_name' => 'the Republic of Angola',
                'capital' => 'Luanda',
                'code' => 'ao',
                'code_alpha3' => 'ago',
                'code_numeric' => 24,
                'emoji' => '🇦🇴',
                'has_division' => 0,
                'currency_code' => 'AOA',
                'currency_name' => 'Kwanza',
                'tld' => '.ao',
                'callingcode' => '244',
            ),
            12 => 
            array (
                'id' => 13,
                'continent_id' => 3,
                'name' => 'Libya',
                'full_name' => 'State of Libya',
                'capital' => 'Tripoli',
                'code' => 'ly',
                'code_alpha3' => 'lby',
                'code_numeric' => 434,
                'emoji' => '🇱🇾',
                'has_division' => 0,
                'currency_code' => 'LYD',
                'currency_name' => 'Libyan Dinar',
                'tld' => '.ly',
                'callingcode' => '218',
            ),
            13 => 
            array (
                'id' => 14,
                'continent_id' => 3,
                'name' => 'Zimbabwe',
                'full_name' => 'the Republic of Zimbabwe',
                'capital' => 'Harare',
                'code' => 'zw',
                'code_alpha3' => 'zwe',
                'code_numeric' => 716,
                'emoji' => '🇿🇼',
                'has_division' => 0,
                'currency_code' => 'ZWL',
                'currency_name' => 'Zimbabwe Dollar',
                'tld' => '.zw',
                'callingcode' => '263',
            ),
            14 => 
            array (
                'id' => 15,
                'continent_id' => 3,
                'name' => 'Guinea',
                'full_name' => 'The Republic of Guinea',
                'capital' => 'Conakry',
                'code' => 'gn',
                'code_alpha3' => 'gin',
                'code_numeric' => 324,
                'emoji' => '🇬🇳',
                'has_division' => 0,
                'currency_code' => 'GNF',
                'currency_name' => 'Guinea Franc',
                'tld' => '.gn',
                'callingcode' => '224',
            ),
            15 => 
            array (
                'id' => 16,
                'continent_id' => 3,
                'name' => 'Sierra Leone',
                'full_name' => 'The Republic of Sierra Leone',
                'capital' => 'Freetown',
                'code' => 'sl',
                'code_alpha3' => 'sle',
                'code_numeric' => 694,
                'emoji' => '🇸🇱',
                'has_division' => 0,
                'currency_code' => 'SLL',
                'currency_name' => 'Leone',
                'tld' => '.sl',
                'callingcode' => '232',
            ),
            16 => 
            array (
                'id' => 17,
                'continent_id' => 3,
                'name' => 'Reunion',
                'full_name' => 'Reunion Island',
                'capital' => 'Saint-Denis',
                'code' => 're',
                'code_alpha3' => 'reu',
                'code_numeric' => 638,
                'emoji' => '🇷🇪',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.re',
                'callingcode' => '262',
            ),
            17 => 
            array (
                'id' => 18,
                'continent_id' => 3,
                'name' => 'Gabon',
                'full_name' => 'The Gabonese Republic',
                'capital' => 'Libreville',
                'code' => 'ga',
                'code_alpha3' => 'gab',
                'code_numeric' => 266,
                'emoji' => '🇬🇦',
                'has_division' => 0,
                'currency_code' => 'XAF',
                'currency_name' => 'CFA Franc BEAC',
                'tld' => '.ga',
                'callingcode' => '241',
            ),
            18 => 
            array (
                'id' => 19,
                'continent_id' => 3,
                'name' => 'Ghana',
                'full_name' => 'The Republic of Ghana',
                'capital' => 'Accra',
                'code' => 'gh',
                'code_alpha3' => 'gha',
                'code_numeric' => 288,
                'emoji' => '🇬🇭',
                'has_division' => 0,
                'currency_code' => 'GHS',
                'currency_name' => 'Ghana Cedi',
                'tld' => '.gh',
                'callingcode' => '233',
            ),
            19 => 
            array (
                'id' => 20,
                'continent_id' => 3,
                'name' => 'Tanzania',
                'full_name' => 'The United Republic of Tanzania',
                'capital' => 'Dodoma',
                'code' => 'tz',
                'code_alpha3' => 'tza',
                'code_numeric' => 834,
                'emoji' => '🇹🇿',
                'has_division' => 0,
                'currency_code' => 'TZS',
                'currency_name' => 'Tanzanian shilling',
                'tld' => '.tz',
                'callingcode' => '255',
            ),
            20 => 
            array (
                'id' => 21,
                'continent_id' => 3,
                'name' => 'Mali',
                'full_name' => 'The Republic of Mali',
                'capital' => 'Bamako',
                'code' => 'ml',
                'code_alpha3' => 'mli',
                'code_numeric' => 466,
                'emoji' => '🇲🇱',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.ml',
                'callingcode' => '223',
            ),
            21 => 
            array (
                'id' => 22,
                'continent_id' => 3,
                'name' => 'Somalia',
                'full_name' => 'The Somalia Democratic Republic',
                'capital' => 'Mogadishu',
                'code' => 'so',
                'code_alpha3' => 'som',
                'code_numeric' => 706,
                'emoji' => '🇸🇴',
                'has_division' => 0,
                'currency_code' => 'SOS',
                'currency_name' => 'Somali Shilling',
                'tld' => '.so',
                'callingcode' => '252',
            ),
            22 => 
            array (
                'id' => 23,
                'continent_id' => 3,
                'name' => 'Mauritania',
                'full_name' => 'The Islamic Republic of Mauritania',
                'capital' => 'Nouakchott',
                'code' => 'mr',
                'code_alpha3' => 'mrt',
                'code_numeric' => 478,
                'emoji' => '🇲🇷',
                'has_division' => 0,
                'currency_code' => 'MRO',
                'currency_name' => 'Ouguiya',
                'tld' => '.mr',
                'callingcode' => '222',
            ),
            23 => 
            array (
                'id' => 24,
                'continent_id' => 3,
                'name' => 'Uganda',
                'full_name' => 'The Republic of Uganda',
                'capital' => 'Kampala',
                'code' => 'ug',
                'code_alpha3' => 'uga',
                'code_numeric' => 800,
                'emoji' => '🇺🇬',
                'has_division' => 0,
                'currency_code' => 'UGX',
                'currency_name' => 'Uganda Shilling',
                'tld' => '.ug',
                'callingcode' => '256',
            ),
            24 => 
            array (
                'id' => 25,
                'continent_id' => 3,
                'name' => 'Chad',
                'full_name' => 'The Republic of Chad',
                'capital' => 'N\'Djamena',
                'code' => 'td',
                'code_alpha3' => 'tcd',
                'code_numeric' => 148,
                'emoji' => '🇹🇩',
                'has_division' => 0,
                'currency_code' => 'XAF',
                'currency_name' => 'CFA Franc BEAC',
                'tld' => '.td',
                'callingcode' => '235',
            ),
            25 => 
            array (
                'id' => 26,
                'continent_id' => 3,
                'name' => 'Mayotte',
                'full_name' => 'Territorial Collectivity of Mayotte',
                'capital' => 'Mamoudzou',
                'code' => 'yt',
                'code_alpha3' => 'myt',
                'code_numeric' => 175,
                'emoji' => '🇾🇹',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.yt',
                'callingcode' => '262',
            ),
            26 => 
            array (
                'id' => 27,
                'continent_id' => 3,
                'name' => 'Comoros',
                'full_name' => 'Union of Comoros',
                'capital' => 'Moroni',
                'code' => 'km',
                'code_alpha3' => 'com',
                'code_numeric' => 174,
                'emoji' => '🇰🇲',
                'has_division' => 0,
                'currency_code' => 'KMF',
                'currency_name' => 'Comoro Franc',
                'tld' => '.km',
                'callingcode' => '269',
            ),
            27 => 
            array (
                'id' => 28,
                'continent_id' => 3,
                'name' => 'Botswana',
                'full_name' => 'The Republic of Botswana',
                'capital' => 'Gaborone',
                'code' => 'bw',
                'code_alpha3' => 'bwa',
                'code_numeric' => 72,
                'emoji' => '🇧🇼',
                'has_division' => 0,
                'currency_code' => 'BWP',
                'currency_name' => 'Pula',
                'tld' => '.bw',
                'callingcode' => '267',
            ),
            28 => 
            array (
                'id' => 29,
                'continent_id' => 3,
                'name' => 'Senegal',
                'full_name' => 'the Republic of Senegal',
                'capital' => 'Dakar',
                'code' => 'sn',
                'code_alpha3' => 'sen',
                'code_numeric' => 686,
                'emoji' => '🇸🇳',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.sn',
                'callingcode' => '221',
            ),
            29 => 
            array (
                'id' => 30,
                'continent_id' => 3,
                'name' => 'Eswatini',
                'full_name' => 'Kingdom of Eswatini',
                'capital' => 'Lobamba',
                'code' => 'sz',
                'code_alpha3' => 'swz',
                'code_numeric' => 748,
                'emoji' => '🇸🇿',
                'has_division' => 0,
                'currency_code' => 'SZL',
                'currency_name' => 'Lilangeni',
                'tld' => '.sz',
                'callingcode' => '268',
            ),
            30 => 
            array (
                'id' => 31,
                'continent_id' => 3,
                'name' => 'Guinea-Bissau',
                'full_name' => 'The Republic of Guinea-Bissau',
                'capital' => 'Bissau',
                'code' => 'gw',
                'code_alpha3' => 'gnb',
                'code_numeric' => 624,
                'emoji' => '🇬🇼',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.gw',
                'callingcode' => '245',
            ),
            31 => 
            array (
                'id' => 32,
                'continent_id' => 3,
                'name' => 'DR Congo',
                'full_name' => 'Democratic Republic of the Congo',
                'capital' => 'Kinshasa',
                'code' => 'cd',
                'code_alpha3' => 'cod',
                'code_numeric' => 180,
                'emoji' => '🇨🇩',
                'has_division' => 0,
                'currency_code' => 'CDF',
                'currency_name' => 'Congolese franc',
                'tld' => '.cd',
                'callingcode' => '242',
            ),
            32 => 
            array (
                'id' => 33,
                'continent_id' => 3,
                'name' => 'Central African Republic',
                'full_name' => 'The Central African Republic',
                'capital' => 'Bangui',
                'code' => 'cf',
                'code_alpha3' => 'caf',
                'code_numeric' => 140,
                'emoji' => '🇨🇫',
                'has_division' => 0,
                'currency_code' => 'XAF',
                'currency_name' => 'CFA Franc BEAC',
                'tld' => '.cf',
                'callingcode' => '236',
            ),
            33 => 
            array (
                'id' => 34,
                'continent_id' => 3,
                'name' => 'Lesotho',
                'full_name' => 'The Kingdom of Lesotho',
                'capital' => 'Maseru',
                'code' => 'ls',
                'code_alpha3' => 'lso',
                'code_numeric' => 426,
                'emoji' => '🇱🇸',
                'has_division' => 0,
                'currency_code' => 'LSL',
                'currency_name' => 'Lesotho loti',
                'tld' => '.ls',
                'callingcode' => '266',
            ),
            34 => 
            array (
                'id' => 35,
                'continent_id' => 3,
                'name' => 'Congo',
                'full_name' => 'Republic of the Congo',
                'capital' => 'Brazzaville',
                'code' => 'cg',
                'code_alpha3' => 'cog',
                'code_numeric' => 178,
                'emoji' => '🇨🇬',
                'has_division' => 0,
                'currency_code' => 'XAF',
                'currency_name' => 'CFA Franc BEAC',
                'tld' => '.cg',
                'callingcode' => '242',
            ),
            35 => 
            array (
                'id' => 36,
                'continent_id' => 3,
                'name' => 'South Africa',
                'full_name' => 'The Republic of South Africa',
                'capital' => 'Pretoria',
                'code' => 'za',
                'code_alpha3' => 'zaf',
                'code_numeric' => 710,
                'emoji' => '🇿🇦',
                'has_division' => 0,
                'currency_code' => 'ZAR',
                'currency_name' => 'Rand',
                'tld' => '.za',
                'callingcode' => '27',
            ),
            36 => 
            array (
                'id' => 37,
                'continent_id' => 3,
                'name' => 'Liberia',
                'full_name' => 'The Republic of Liberia',
                'capital' => 'Monrovia',
                'code' => 'lr',
                'code_alpha3' => 'lbr',
                'code_numeric' => 430,
                'emoji' => '🇱🇷',
                'has_division' => 0,
                'currency_code' => 'LRD',
                'currency_name' => 'Liberian Dollar',
                'tld' => '.lr',
                'callingcode' => '231',
            ),
            37 => 
            array (
                'id' => 38,
                'continent_id' => 3,
                'name' => 'Tunisia',
                'full_name' => 'The Republic of Tunisia',
                'capital' => 'Tunis',
                'code' => 'tn',
                'code_alpha3' => 'tun',
                'code_numeric' => 788,
                'emoji' => '🇹🇳',
                'has_division' => 0,
                'currency_code' => 'TND',
                'currency_name' => 'Tunisian Dinar',
                'tld' => '.tn',
                'callingcode' => '216',
            ),
            38 => 
            array (
                'id' => 39,
                'continent_id' => 3,
                'name' => 'Zambia',
                'full_name' => 'The Republic of Zambia',
                'capital' => 'Lusaka',
                'code' => 'zm',
                'code_alpha3' => 'zmb',
                'code_numeric' => 894,
                'emoji' => '🇿🇲',
                'has_division' => 0,
                'currency_code' => 'ZMW',
                'currency_name' => 'Zambian Kwacha',
                'tld' => '.zm',
                'callingcode' => '260',
            ),
            39 => 
            array (
                'id' => 40,
                'continent_id' => 3,
                'name' => 'Niger',
                'full_name' => 'The Republic of Niger',
                'capital' => 'Niamey',
                'code' => 'ne',
                'code_alpha3' => 'ner',
                'code_numeric' => 562,
                'emoji' => '🇳🇪',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.ne',
                'callingcode' => '227',
            ),
            40 => 
            array (
                'id' => 41,
                'continent_id' => 3,
                'name' => 'Western Sahara',
                'full_name' => 'the Sahrawi Arab Democratic Republic Western Sahara',
                'capital' => 'El Aaiún',
                'code' => 'eh',
                'code_alpha3' => 'esh',
                'code_numeric' => 732,
                'emoji' => '🇪🇭',
                'has_division' => 0,
                'currency_code' => 'DZD',
                'currency_name' => 'Algerian dinar',
                'tld' => '.eh',
                'callingcode' => '212',
            ),
            41 => 
            array (
                'id' => 42,
                'continent_id' => 3,
                'name' => 'Togo',
                'full_name' => 'The Republic of Togo',
                'capital' => 'Lomé',
                'code' => 'tg',
                'code_alpha3' => 'tgo',
                'code_numeric' => 768,
                'emoji' => '🇹🇬',
                'has_division' => 0,
                'currency_code' => 'XOF',
                'currency_name' => 'CFA Franc BCEAO',
                'tld' => '.tg',
                'callingcode' => '228',
            ),
            42 => 
            array (
                'id' => 43,
                'continent_id' => 3,
                'name' => 'Namibia',
                'full_name' => 'The Republic of Namibia',
                'capital' => 'Windhoek',
                'code' => 'na',
                'code_alpha3' => 'nam',
                'code_numeric' => 516,
                'emoji' => '🇳🇦',
                'has_division' => 0,
                'currency_code' => 'NAD',
                'currency_name' => 'Namibian dollar',
                'tld' => '.na',
                'callingcode' => '264',
            ),
            43 => 
            array (
                'id' => 44,
                'continent_id' => 3,
                'name' => 'Mozambique',
                'full_name' => 'The Republic of Mozambique',
                'capital' => 'Maputo',
                'code' => 'mz',
                'code_alpha3' => 'moz',
                'code_numeric' => 508,
                'emoji' => '🇲🇿',
                'has_division' => 0,
                'currency_code' => 'MZN',
                'currency_name' => 'Mozambique Metical',
                'tld' => '.mz',
                'callingcode' => '258',
            ),
            44 => 
            array (
                'id' => 45,
                'continent_id' => 3,
                'name' => 'Ethiopia',
                'full_name' => 'The Federal Democratic Republic of Ethiopia',
                'capital' => 'Addis Ababa',
                'code' => 'et',
                'code_alpha3' => 'eth',
                'code_numeric' => 231,
                'emoji' => '🇪🇹',
                'has_division' => 0,
                'currency_code' => 'ETB',
                'currency_name' => 'Ethiopian Birr',
                'tld' => '.et',
                'callingcode' => '251',
            ),
            45 => 
            array (
                'id' => 46,
                'continent_id' => 3,
                'name' => 'Morocco',
                'full_name' => 'The Kingdom of Morocco',
                'capital' => 'Rabat',
                'code' => 'ma',
                'code_alpha3' => 'mar',
                'code_numeric' => 504,
                'emoji' => '🇲🇦',
                'has_division' => 0,
                'currency_code' => 'MAD',
                'currency_name' => 'Moroccan Dirham',
                'tld' => '.ma',
                'callingcode' => '212',
            ),
            46 => 
            array (
                'id' => 47,
                'continent_id' => 3,
                'name' => 'Malawi',
                'full_name' => 'The Republic of Malawi',
                'capital' => 'Lilongwe',
                'code' => 'mw',
                'code_alpha3' => 'mwi',
                'code_numeric' => 454,
                'emoji' => '🇲🇼',
                'has_division' => 0,
                'currency_code' => 'MWK',
                'currency_name' => 'Kwacha',
                'tld' => '.mw',
                'callingcode' => '265',
            ),
            47 => 
            array (
                'id' => 48,
                'continent_id' => 3,
                'name' => 'Nigeria',
                'full_name' => 'Federal Republic of Nigeria',
                'capital' => 'Abuja',
                'code' => 'ng',
                'code_alpha3' => 'nga',
                'code_numeric' => 566,
                'emoji' => '🇳🇬',
                'has_division' => 0,
                'currency_code' => 'NGN',
                'currency_name' => 'Naira',
                'tld' => '.ng',
                'callingcode' => '234',
            ),
            48 => 
            array (
                'id' => 49,
                'continent_id' => 3,
                'name' => 'Cabo Verde',
                'full_name' => 'Republic of Cabo Verde',
                'capital' => 'Praia',
                'code' => 'cv',
                'code_alpha3' => 'cpv',
                'code_numeric' => 132,
                'emoji' => '🇨🇻',
                'has_division' => 0,
                'currency_code' => 'CVE',
                'currency_name' => 'Cabo Verde Escudo',
                'tld' => '.cv',
                'callingcode' => '238',
            ),
            49 => 
            array (
                'id' => 50,
                'continent_id' => 3,
                'name' => 'Burundi',
                'full_name' => 'The Republic of Burundi',
                'capital' => 'Bujumbura',
                'code' => 'bi',
                'code_alpha3' => 'bdi',
                'code_numeric' => 108,
                'emoji' => '🇧🇮',
                'has_division' => 0,
                'currency_code' => 'BIF',
                'currency_name' => 'Burundi Franc',
                'tld' => '.bi',
                'callingcode' => '257',
            ),
            50 => 
            array (
                'id' => 51,
                'continent_id' => 3,
                'name' => 'Algeria',
                'full_name' => 'People\'s Democratic Republic of Algeria',
                'capital' => 'Algiers',
                'code' => 'dz',
                'code_alpha3' => 'dza',
                'code_numeric' => 12,
                'emoji' => '🇩🇿',
                'has_division' => 0,
                'currency_code' => 'DZD',
                'currency_name' => 'Algerian Dinar',
                'tld' => '.dz',
                'callingcode' => '213',
            ),
            51 => 
            array (
                'id' => 52,
                'continent_id' => 3,
                'name' => 'Djibouti',
                'full_name' => 'The Republic of Djibouti',
                'capital' => 'Djibouti',
                'code' => 'dj',
                'code_alpha3' => 'dji',
                'code_numeric' => 262,
                'emoji' => '🇩🇯',
                'has_division' => 0,
                'currency_code' => 'DJF',
                'currency_name' => 'Djibouti Franc',
                'tld' => '.dj',
                'callingcode' => '253',
            ),
            52 => 
            array (
                'id' => 53,
                'continent_id' => 6,
                'name' => 'Guadeloupe',
                'full_name' => 'Guadeloupe ',
                'capital' => 'Basse-Terre',
                'code' => 'gp',
                'code_alpha3' => 'glp',
                'code_numeric' => 312,
                'emoji' => '🇬🇵',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.gp',
                'callingcode' => '590',
            ),
            53 => 
            array (
                'id' => 54,
                'continent_id' => 3,
                'name' => 'Equatorial Guinea',
                'full_name' => 'The Republic of Equatorial Guinea',
                'capital' => 'Malabo',
                'code' => 'gq',
                'code_alpha3' => 'gnq',
                'code_numeric' => 226,
                'emoji' => '🇬🇶',
                'has_division' => 0,
                'currency_code' => 'XAF',
                'currency_name' => 'CFA Franc BEAC',
                'tld' => '.gq',
                'callingcode' => '240',
            ),
            54 => 
            array (
                'id' => 55,
                'continent_id' => 3,
                'name' => 'Sudan',
                'full_name' => 'The Republic of Sudan',
                'capital' => 'Khartoum',
                'code' => 'sd',
                'code_alpha3' => 'sdn',
                'code_numeric' => 729,
                'emoji' => '🇸🇩',
                'has_division' => 1,
                'currency_code' => 'SDG',
                'currency_name' => 'Sudanese Pound',
                'tld' => '.sd',
                'callingcode' => '249',
            ),
            55 => 
            array (
                'id' => 56,
                'continent_id' => 3,
                'name' => 'Kenya',
                'full_name' => 'The Republic of Kenya',
                'capital' => 'Nairobi',
                'code' => 'ke',
                'code_alpha3' => 'ken',
                'code_numeric' => 404,
                'emoji' => '🇰🇪',
                'has_division' => 0,
                'currency_code' => 'KES',
                'currency_name' => 'Kenyan Shilling',
                'tld' => '.ke',
                'callingcode' => '254',
            ),
            56 => 
            array (
                'id' => 57,
                'continent_id' => 1,
                'name' => 'Singapore',
                'full_name' => 'Republic of Singapore',
                'capital' => 'Singapore',
                'code' => 'sg',
                'code_alpha3' => 'sgp',
                'code_numeric' => 702,
                'emoji' => '🇸🇬',
                'has_division' => 0,
                'currency_code' => 'SGD',
                'currency_name' => 'Singapore Dollar',
                'tld' => '.sg',
                'callingcode' => '65',
            ),
            57 => 
            array (
                'id' => 58,
                'continent_id' => 1,
                'name' => 'South Korea',
                'full_name' => 'Republic of Korea',
                'capital' => 'Seoul',
                'code' => 'kr',
                'code_alpha3' => 'kor',
                'code_numeric' => 410,
                'emoji' => '🇰🇷',
                'has_division' => 1,
                'currency_code' => 'KRW',
                'currency_name' => 'South Korean won',
                'tld' => '.kr',
                'callingcode' => '82',
            ),
            58 => 
            array (
                'id' => 59,
                'continent_id' => 1,
                'name' => 'Syria',
                'full_name' => 'Syrian Arab Republic',
                'capital' => 'Damascus',
                'code' => 'sy',
                'code_alpha3' => 'syr',
                'code_numeric' => 760,
                'emoji' => '🇸🇾',
                'has_division' => 0,
                'currency_code' => 'SYP',
                'currency_name' => 'Syrian Pound',
                'tld' => '.sy',
                'callingcode' => '963',
            ),
            59 => 
            array (
                'id' => 60,
                'continent_id' => 1,
                'name' => 'Uzbekistan',
                'full_name' => 'The Republic of Uzbekistan',
                'capital' => 'Tashkent',
                'code' => 'uz',
                'code_alpha3' => 'uzb',
                'code_numeric' => 860,
                'emoji' => '🇺🇿',
                'has_division' => 0,
                'currency_code' => 'UZS',
                'currency_name' => 'Uzbekistan Sum',
                'tld' => '.uz',
                'callingcode' => '998',
            ),
            60 => 
            array (
                'id' => 61,
                'continent_id' => 1,
                'name' => 'Bahrain',
                'full_name' => 'The Kingdom of Bahrain',
                'capital' => 'Manama',
                'code' => 'bh',
                'code_alpha3' => 'bhr',
                'code_numeric' => 48,
                'emoji' => '🇧🇭',
                'has_division' => 0,
                'currency_code' => 'BHD',
                'currency_name' => 'Bahraini Dinar',
                'tld' => '.bh',
                'callingcode' => '973',
            ),
            61 => 
            array (
                'id' => 62,
                'continent_id' => 1,
                'name' => 'Japan',
                'full_name' => 'Japan',
                'capital' => 'Tokyo',
                'code' => 'jp',
                'code_alpha3' => 'jpn',
                'code_numeric' => 392,
                'emoji' => '🇯🇵',
                'has_division' => 0,
                'currency_code' => 'JPY',
                'currency_name' => 'Yen',
                'tld' => '.jp',
                'callingcode' => '81',
            ),
            62 => 
            array (
                'id' => 63,
                'continent_id' => 1,
                'name' => 'Jordan',
                'full_name' => 'The Hashemite Kingdom of Jordan',
                'capital' => 'Amman',
                'code' => 'jo',
                'code_alpha3' => 'jor',
                'code_numeric' => 400,
                'emoji' => '🇯🇴',
                'has_division' => 0,
                'currency_code' => 'JOD',
                'currency_name' => 'Jordanian Dinar',
                'tld' => '.jo',
                'callingcode' => '962',
            ),
            63 => 
            array (
                'id' => 64,
                'continent_id' => 1,
                'name' => 'Vietnam',
                'full_name' => 'Socialist Republic of Vietnam',
                'capital' => 'Hanoi',
                'code' => 'vn',
                'code_alpha3' => 'vnm',
                'code_numeric' => 704,
                'emoji' => '🇻🇳',
                'has_division' => 0,
                'currency_code' => 'VND',
                'currency_name' => 'Dong',
                'tld' => '.vn',
                'callingcode' => '84',
            ),
            64 => 
            array (
                'id' => 65,
                'continent_id' => 1,
                'name' => 'Kyrgyzstan',
                'full_name' => 'The Kyrgyz Republic',
                'capital' => 'Bishkek',
                'code' => 'kg',
                'code_alpha3' => 'kgz',
                'code_numeric' => 417,
                'emoji' => '🇰🇬',
                'has_division' => 0,
                'currency_code' => 'KGS',
                'currency_name' => 'Som',
                'tld' => '.kg',
                'callingcode' => '996',
            ),
            65 => 
            array (
                'id' => 66,
                'continent_id' => 1,
                'name' => 'Thailand',
                'full_name' => 'Kingdom of Thailand',
                'capital' => 'Bangkok',
                'code' => 'th',
                'code_alpha3' => 'tha',
                'code_numeric' => 764,
                'emoji' => '🇹🇭',
                'has_division' => 0,
                'currency_code' => 'THB',
                'currency_name' => 'Baht',
                'tld' => '.th',
                'callingcode' => '66',
            ),
            66 => 
            array (
                'id' => 67,
                'continent_id' => 1,
                'name' => 'Sri Lanka',
                'full_name' => 'The Democratic Socialist Republic of Sri Lanka',
                'capital' => 'Colombo',
                'code' => 'lk',
                'code_alpha3' => 'lka',
                'code_numeric' => 144,
                'emoji' => '🇱🇰',
                'has_division' => 0,
                'currency_code' => 'LKR',
                'currency_name' => 'Sri Lanka Rupee',
                'tld' => '.lk',
                'callingcode' => '94',
            ),
            67 => 
            array (
                'id' => 68,
                'continent_id' => 1,
                'name' => 'United Arab Emirates',
                'full_name' => 'The United Arab Emirates',
                'capital' => 'Abu Dhabi',
                'code' => 'ae',
                'code_alpha3' => 'are',
                'code_numeric' => 784,
                'emoji' => '🇦🇪',
                'has_division' => 0,
                'currency_code' => 'AED',
                'currency_name' => 'UAE Dirham',
                'tld' => '.ae',
                'callingcode' => '971',
            ),
            68 => 
            array (
                'id' => 69,
                'continent_id' => 1,
                'name' => 'Laos',
                'full_name' => 'Lao People\'s Democratic Republic',
                'capital' => 'Vientiane',
                'code' => 'la',
                'code_alpha3' => 'lao',
                'code_numeric' => 418,
                'emoji' => '🇱🇦',
                'has_division' => 0,
                'currency_code' => 'LAK',
                'currency_name' => 'Kip',
                'tld' => '.la',
                'callingcode' => '856',
            ),
            69 => 
            array (
                'id' => 70,
                'continent_id' => 1,
                'name' => 'Afghanistan',
                'full_name' => 'the Islamic Republic of Afghanistan',
                'capital' => 'Kabul',
                'code' => 'af',
                'code_alpha3' => 'afg',
                'code_numeric' => 4,
                'emoji' => '🇦🇫',
                'has_division' => 0,
                'currency_code' => 'AFN',
                'currency_name' => 'Afghani',
                'tld' => '.af',
                'callingcode' => '93',
            ),
            70 => 
            array (
                'id' => 71,
                'continent_id' => 1,
                'name' => 'Macau',
                'full_name' => 'Macao Special Administrative Region',
                'capital' => '',
                'code' => 'mo',
                'code_alpha3' => 'mac',
                'code_numeric' => 446,
                'emoji' => '🇲🇴',
                'has_division' => 0,
                'currency_code' => 'MOP',
                'currency_name' => 'Macanese pataca',
                'tld' => '.mo',
                'callingcode' => '853',
            ),
            71 => 
            array (
                'id' => 72,
                'continent_id' => 1,
                'name' => 'Tajikistan',
                'full_name' => 'The Republic of Tajikistan',
                'capital' => 'Dushanbe',
                'code' => 'tj',
                'code_alpha3' => 'tjk',
                'code_numeric' => 762,
                'emoji' => '🇹🇯',
                'has_division' => 0,
                'currency_code' => 'TJS',
                'currency_name' => 'Somoni',
                'tld' => '.tj',
                'callingcode' => '992',
            ),
            72 => 
            array (
                'id' => 73,
                'continent_id' => 1,
                'name' => 'North Korea',
                'full_name' => 'Democratic People\'s Republic of Korea',
                'capital' => 'Pyongyang',
                'code' => 'kp',
                'code_alpha3' => 'prk',
                'code_numeric' => 408,
                'emoji' => '🇰🇵',
                'has_division' => 0,
                'currency_code' => 'KPW',
                'currency_name' => 'North Korean won',
                'tld' => '.kp',
                'callingcode' => '850',
            ),
            73 => 
            array (
                'id' => 74,
                'continent_id' => 1,
                'name' => 'Palestine',
                'full_name' => 'The State of Palestine',
                'capital' => 'Ramallah',
                'code' => 'ps',
                'code_alpha3' => 'pal',
                'code_numeric' => 275,
                'emoji' => '🇵🇸',
                'has_division' => 0,
                'currency_code' => 'ILS',
                'currency_name' => 'Israeli new shekel',
                'tld' => '.ps',
                'callingcode' => '970',
            ),
            74 => 
            array (
                'id' => 75,
                'continent_id' => 1,
                'name' => 'Hong Kong',
                'full_name' => 'Hong Kong Special Administrative Region',
                'capital' => 'City of Victoria',
                'code' => 'hk',
                'code_alpha3' => 'hkg',
                'code_numeric' => 344,
                'emoji' => '🇭🇰',
                'has_division' => 0,
                'currency_code' => 'HKD',
                'currency_name' => 'Hong Kong dollar',
                'tld' => '.hk',
                'callingcode' => '852',
            ),
            75 => 
            array (
                'id' => 76,
                'continent_id' => 1,
                'name' => 'Iraq',
                'full_name' => 'Republic Of Iraq',
                'capital' => 'Baghdad',
                'code' => 'iq',
                'code_alpha3' => 'irq',
                'code_numeric' => 368,
                'emoji' => '🇮🇶',
                'has_division' => 0,
                'currency_code' => 'IQD',
                'currency_name' => 'Iraqi Dinar',
                'tld' => '.iq',
                'callingcode' => '964',
            ),
            76 => 
            array (
                'id' => 77,
                'continent_id' => 1,
                'name' => 'Lebanon',
                'full_name' => 'The Republic of Lebanon',
                'capital' => 'Beirut',
                'code' => 'lb',
                'code_alpha3' => 'lbn',
                'code_numeric' => 422,
                'emoji' => '🇱🇧',
                'has_division' => 0,
                'currency_code' => 'LBP',
                'currency_name' => 'Lebanese Pound',
                'tld' => '.lb',
                'callingcode' => '961',
            ),
            77 => 
            array (
                'id' => 78,
                'continent_id' => 1,
                'name' => 'Kuwait',
                'full_name' => 'The State of Kuwait',
                'capital' => 'Kuwait City',
                'code' => 'kw',
                'code_alpha3' => 'kwt',
                'code_numeric' => 414,
                'emoji' => '🇰🇼',
                'has_division' => 0,
                'currency_code' => 'KWD',
                'currency_name' => 'Kuwaiti Dinar',
                'tld' => '.kw',
                'callingcode' => '965',
            ),
            78 => 
            array (
                'id' => 79,
                'continent_id' => 1,
                'name' => 'Brunei',
                'full_name' => 'Brunei Darussalam',
                'capital' => 'Bandar Seri Begawan',
                'code' => 'bn',
                'code_alpha3' => 'brn',
                'code_numeric' => 96,
                'emoji' => '🇧🇳',
                'has_division' => 0,
                'currency_code' => 'BND',
                'currency_name' => 'Brunei Dollar',
                'tld' => '.bn',
                'callingcode' => '673',
            ),
            79 => 
            array (
                'id' => 80,
                'continent_id' => 1,
                'name' => 'Maldives',
                'full_name' => 'The Republic of Maldives',
                'capital' => 'Malé',
                'code' => 'mv',
                'code_alpha3' => 'mdv',
                'code_numeric' => 462,
                'emoji' => '🇲🇻',
                'has_division' => 0,
                'currency_code' => 'MVR',
                'currency_name' => 'Rufiyaa',
                'tld' => '.mv',
                'callingcode' => '960',
            ),
            80 => 
            array (
                'id' => 81,
                'continent_id' => 1,
                'name' => 'Indonesia',
                'full_name' => 'The Republic of Indonesia',
                'capital' => 'Jakarta',
                'code' => 'id',
                'code_alpha3' => 'idn',
                'code_numeric' => 360,
                'emoji' => '🇮🇩',
                'has_division' => 1,
                'currency_code' => 'IDR',
                'currency_name' => 'Rupiah',
                'tld' => '.id',
                'callingcode' => '62',
            ),
            81 => 
            array (
                'id' => 82,
                'continent_id' => 1,
                'name' => 'Israel',
                'full_name' => 'The State of Israel',
                'capital' => 'Jerusalem',
                'code' => 'il',
                'code_alpha3' => 'isr',
                'code_numeric' => 376,
                'emoji' => '🇮🇱',
                'has_division' => 0,
                'currency_code' => 'ILS',
                'currency_name' => 'New Israeli Sheqel',
                'tld' => '.il',
                'callingcode' => '972',
            ),
            82 => 
            array (
                'id' => 83,
                'continent_id' => 1,
                'name' => 'Mongolia',
                'full_name' => 'Mongolia',
                'capital' => 'Ulan Bator',
                'code' => 'mn',
                'code_alpha3' => 'mng',
                'code_numeric' => 496,
                'emoji' => '🇲🇳',
                'has_division' => 0,
                'currency_code' => 'MNT',
                'currency_name' => 'Tugrik',
                'tld' => '.mn',
                'callingcode' => '976',
            ),
            83 => 
            array (
                'id' => 84,
                'continent_id' => 1,
                'name' => 'Oman',
                'full_name' => 'Sultanate of Oman',
                'capital' => 'Muscat',
                'code' => 'om',
                'code_alpha3' => 'omn',
                'code_numeric' => 512,
                'emoji' => '🇴🇲',
                'has_division' => 0,
                'currency_code' => 'OMR',
                'currency_name' => 'Rial Omani',
                'tld' => '.om',
                'callingcode' => '968',
            ),
            84 => 
            array (
                'id' => 85,
                'continent_id' => 1,
                'name' => 'India',
                'full_name' => 'The Republic of India',
                'capital' => 'New Delhi',
                'code' => 'in',
                'code_alpha3' => 'ind',
                'code_numeric' => 356,
                'emoji' => '🇮🇳',
                'has_division' => 1,
                'currency_code' => 'INR',
                'currency_name' => 'Indian Rupee',
                'tld' => '.in',
                'callingcode' => '91',
            ),
            85 => 
            array (
                'id' => 86,
                'continent_id' => 1,
                'name' => 'Myanmar',
                'full_name' => 'Republic Of The Union Of Myanmar',
                'capital' => 'Naypyidaw',
                'code' => 'mm',
                'code_alpha3' => 'mmr',
                'code_numeric' => 104,
                'emoji' => '🇲🇲',
                'has_division' => 0,
                'currency_code' => 'MMK',
                'currency_name' => 'Kyat',
                'tld' => '.mm',
                'callingcode' => '95',
            ),
            86 => 
            array (
                'id' => 87,
                'continent_id' => 1,
                'name' => 'Malaysia',
                'full_name' => 'Malaysia',
                'capital' => 'Kuala Lumpur',
                'code' => 'my',
                'code_alpha3' => 'mys',
                'code_numeric' => 458,
                'emoji' => '🇲🇾',
                'has_division' => 1,
                'currency_code' => 'MYR',
                'currency_name' => 'Malaysian Ringgit',
                'tld' => '.my',
                'callingcode' => '60',
            ),
            87 => 
            array (
                'id' => 88,
                'continent_id' => 1,
                'name' => 'East Timor',
                'full_name' => 'Democratic Republic of East Timor',
                'capital' => 'Dili',
                'code' => 'tl',
                'code_alpha3' => 'tmp',
                'code_numeric' => 626,
                'emoji' => '🇹🇱',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.tl',
                'callingcode' => '670',
            ),
            88 => 
            array (
                'id' => 89,
                'continent_id' => 1,
                'name' => 'Yemen',
                'full_name' => 'The Republic of Yemen',
                'capital' => 'Sana\'a',
                'code' => 'ye',
                'code_alpha3' => 'yem',
                'code_numeric' => 887,
                'emoji' => '🇾🇪',
                'has_division' => 0,
                'currency_code' => 'YER',
                'currency_name' => 'Yemeni Rial',
                'tld' => '.ye',
                'callingcode' => '967',
            ),
            89 => 
            array (
                'id' => 90,
                'continent_id' => 1,
                'name' => 'Bhutan',
                'full_name' => 'Kingdom of Bhutan',
                'capital' => 'Thimphu',
                'code' => 'bt',
                'code_alpha3' => 'btn',
                'code_numeric' => 64,
                'emoji' => '🇧🇹',
                'has_division' => 0,
                'currency_code' => 'BTN',
                'currency_name' => 'Bhutanese ngultrum',
                'tld' => '.bt',
                'callingcode' => '975',
            ),
            90 => 
            array (
                'id' => 91,
                'continent_id' => 1,
                'name' => 'Cambodia',
                'full_name' => 'Kingdom of Cambodia',
                'capital' => 'Phnom Penh',
                'code' => 'kh',
                'code_alpha3' => 'khm',
                'code_numeric' => 116,
                'emoji' => '🇰🇭',
                'has_division' => 0,
                'currency_code' => 'KHR',
                'currency_name' => 'Riel',
                'tld' => '.kh',
                'callingcode' => '855',
            ),
            91 => 
            array (
                'id' => 92,
                'continent_id' => 1,
                'name' => 'Pakistan',
                'full_name' => 'the Islamic Republic of Pakistan',
                'capital' => 'Islamabad',
                'code' => 'pk',
                'code_alpha3' => 'pak',
                'code_numeric' => 586,
                'emoji' => '🇵🇰',
                'has_division' => 0,
                'currency_code' => 'PKR',
                'currency_name' => 'Pakistan Rupee',
                'tld' => '.pk',
                'callingcode' => '92',
            ),
            92 => 
            array (
                'id' => 93,
                'continent_id' => 1,
                'name' => 'Bangladesh',
                'full_name' => 'People\'s Republic of Bangladesh',
                'capital' => 'Dhaka',
                'code' => 'bd',
                'code_alpha3' => 'bgd',
                'code_numeric' => 50,
                'emoji' => '🇧🇩',
                'has_division' => 0,
                'currency_code' => 'BDT',
                'currency_name' => 'Taka',
                'tld' => '.bd',
                'callingcode' => '880',
            ),
            93 => 
            array (
                'id' => 94,
                'continent_id' => 1,
                'name' => 'Saudi Arabia',
                'full_name' => 'Kingdom of Saudi Arabia',
                'capital' => 'Riyadh',
                'code' => 'sa',
                'code_alpha3' => 'sau',
                'code_numeric' => 682,
                'emoji' => '🇸🇦',
                'has_division' => 1,
                'currency_code' => 'SAR',
                'currency_name' => 'Saudi Riyal',
                'tld' => '.sa',
                'callingcode' => '966',
            ),
            94 => 
            array (
                'id' => 95,
                'continent_id' => 1,
                'name' => 'Turkmenistan',
                'full_name' => 'Turkmenistan',
                'capital' => 'Ashgabat',
                'code' => 'tm',
                'code_alpha3' => 'tkm',
                'code_numeric' => 795,
                'emoji' => '🇹🇲',
                'has_division' => 0,
                'currency_code' => 'TMT',
                'currency_name' => 'Turkmenistan New Manat',
                'tld' => '.tm',
                'callingcode' => '993',
            ),
            95 => 
            array (
                'id' => 96,
                'continent_id' => 1,
                'name' => 'Qatar',
                'full_name' => 'The State of Qatar',
                'capital' => 'Doha',
                'code' => 'qa',
                'code_alpha3' => 'qat',
                'code_numeric' => 634,
                'emoji' => '🇶🇦',
                'has_division' => 0,
                'currency_code' => 'QAR',
                'currency_name' => 'Qatari Rial',
                'tld' => '.qa',
                'callingcode' => '974',
            ),
            96 => 
            array (
                'id' => 97,
                'continent_id' => 1,
                'name' => 'Nepal',
                'full_name' => 'Federal Democratic Republic of Nepal',
                'capital' => 'Kathmandu',
                'code' => 'np',
                'code_alpha3' => 'npl',
                'code_numeric' => 524,
                'emoji' => '🇳🇵',
                'has_division' => 1,
                'currency_code' => 'NPR',
                'currency_name' => 'Nepalese Rupee',
                'tld' => '.np',
                'callingcode' => '977',
            ),
            97 => 
            array (
                'id' => 98,
                'continent_id' => 1,
                'name' => 'Kazakhstan',
                'full_name' => 'The Republic of Kazakhstan',
                'capital' => 'Astana',
                'code' => 'kz',
                'code_alpha3' => 'kaz',
                'code_numeric' => 398,
                'emoji' => '🇰🇿',
                'has_division' => 0,
                'currency_code' => 'KZT',
                'currency_name' => 'Tenge',
                'tld' => '.kz',
                'callingcode' => '7',
            ),
            98 => 
            array (
                'id' => 99,
                'continent_id' => 1,
                'name' => 'Philippines',
                'full_name' => 'Republic of the Philippines',
                'capital' => 'Manila',
                'code' => 'ph',
                'code_alpha3' => 'phl',
                'code_numeric' => 608,
                'emoji' => '🇵🇭',
                'has_division' => 0,
                'currency_code' => 'PHP',
                'currency_name' => 'Philippine Peso',
                'tld' => '.ph',
                'callingcode' => '63',
            ),
            99 => 
            array (
                'id' => 100,
                'continent_id' => 1,
                'name' => 'Taiwan',
                'full_name' => 'Taiwan',
                'capital' => 'Taipei',
                'code' => 'tw',
                'code_alpha3' => 'twn',
                'code_numeric' => 158,
                'emoji' => '🇹🇼',
                'has_division' => 0,
                'currency_code' => 'TWD',
                'currency_name' => 'New Taiwan dollar',
                'tld' => '.tw',
                'callingcode' => '886',
            ),
            100 => 
            array (
                'id' => 101,
                'continent_id' => 1,
                'name' => 'China',
                'full_name' => 'People\'s Republic of China',
                'capital' => 'Beijing',
                'code' => 'cn',
                'code_alpha3' => 'chn',
                'code_numeric' => 156,
                'emoji' => '🇨🇳',
                'has_division' => 1,
                'currency_code' => 'CNY',
                'currency_name' => 'Yuan Renminbi',
                'tld' => '.cn',
                'callingcode' => '86',
            ),
            101 => 
            array (
                'id' => 102,
                'continent_id' => 1,
                'name' => 'Iran',
                'full_name' => 'The Islamic Republic of Iran',
                'capital' => 'Tehran',
                'code' => 'ir',
                'code_alpha3' => 'irn',
                'code_numeric' => 364,
                'emoji' => '🇮🇷',
                'has_division' => 0,
                'currency_code' => 'IRR',
                'currency_name' => 'Iranian rial',
                'tld' => '.ir',
                'callingcode' => '98',
            ),
            102 => 
            array (
                'id' => 103,
                'continent_id' => 6,
                'name' => 'Costa Rica',
                'full_name' => 'Republic of Costa Rica',
                'capital' => 'San José',
                'code' => 'cr',
                'code_alpha3' => 'cri',
                'code_numeric' => 188,
                'emoji' => '🇨🇷',
                'has_division' => 0,
                'currency_code' => 'CRC',
                'currency_name' => 'Costa Rican Colon',
                'tld' => '.cr',
                'callingcode' => '506',
            ),
            103 => 
            array (
                'id' => 104,
                'continent_id' => 6,
                'name' => 'Cuba',
                'full_name' => 'The Republic of Cuba',
                'capital' => 'Havana',
                'code' => 'cu',
                'code_alpha3' => 'cub',
                'code_numeric' => 192,
                'emoji' => '🇨🇺',
                'has_division' => 1,
                'currency_code' => 'CUC',
                'currency_name' => 'Cuban convertible peso',
                'tld' => '.cu',
                'callingcode' => '53',
            ),
            104 => 
            array (
                'id' => 105,
                'continent_id' => 6,
                'name' => 'Dominican',
                'full_name' => 'The Dominican Republic',
                'capital' => 'Santo Domingo',
                'code' => 'do',
                'code_alpha3' => 'dom',
                'code_numeric' => 214,
                'emoji' => '🇩🇴',
                'has_division' => 1,
                'currency_code' => 'DOP',
                'currency_name' => 'Dominican Peso',
                'tld' => '.do',
                'callingcode' => '1809',
            ),
            105 => 
            array (
                'id' => 106,
                'continent_id' => 6,
                'name' => 'Mexico',
                'full_name' => 'The United States of Mexico',
                'capital' => 'Mexico City',
                'code' => 'mx',
                'code_alpha3' => 'mex',
                'code_numeric' => 484,
                'emoji' => '🇲🇽',
                'has_division' => 1,
                'currency_code' => 'MXN',
                'currency_name' => 'Mexican Peso',
                'tld' => '.mx',
                'callingcode' => '52',
            ),
            106 => 
            array (
                'id' => 107,
                'continent_id' => 6,
                'name' => 'Nicaragua',
                'full_name' => 'The Republic of Nicaragua',
                'capital' => 'Managua',
                'code' => 'ni',
                'code_alpha3' => 'nic',
                'code_numeric' => 558,
                'emoji' => '🇳🇮',
                'has_division' => 0,
                'currency_code' => 'NIO',
                'currency_name' => 'Cordoba Oro',
                'tld' => '.ni',
                'callingcode' => '505',
            ),
            107 => 
            array (
                'id' => 108,
                'continent_id' => 6,
                'name' => 'Panama',
                'full_name' => 'The Republic of Panama',
                'capital' => 'Panama City',
                'code' => 'pa',
                'code_alpha3' => 'pan',
                'code_numeric' => 591,
                'emoji' => '🇵🇦',
                'has_division' => 1,
                'currency_code' => 'PAB',
                'currency_name' => 'Panamanian balboa',
                'tld' => '.pa',
                'callingcode' => '507',
            ),
            108 => 
            array (
                'id' => 109,
                'continent_id' => 7,
                'name' => 'Netherlands Antilles',
                'full_name' => 'Netherlands Antilles',
                'capital' => NULL,
                'code' => 'an',
                'code_alpha3' => 'ant',
                'code_numeric' => NULL,
                'emoji' => NULL,
                'has_division' => 0,
                'currency_code' => NULL,
                'currency_name' => NULL,
                'tld' => NULL,
                'callingcode' => NULL,
            ),
            109 => 
            array (
                'id' => 110,
                'continent_id' => 6,
                'name' => 'El Salvador',
                'full_name' => 'The Republic of El Salvador',
                'capital' => 'San Salvador',
                'code' => 'sv',
                'code_alpha3' => 'slv',
                'code_numeric' => 222,
                'emoji' => '🇸🇻',
                'has_division' => 0,
                'currency_code' => 'SVC',
                'currency_name' => 'Salvadoran colón',
                'tld' => '.sv',
                'callingcode' => '503',
            ),
            110 => 
            array (
                'id' => 111,
                'continent_id' => 6,
                'name' => 'Puerto Rico',
                'full_name' => 'The Commonwealth of Puerto Rico',
                'capital' => 'San Juan',
                'code' => 'pr',
                'code_alpha3' => 'ptr',
                'code_numeric' => 630,
                'emoji' => '🇵🇷',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.pr',
                'callingcode' => '1787',
            ),
            111 => 
            array (
                'id' => 112,
                'continent_id' => 6,
                'name' => 'Saint Vincent and the Grenadines',
                'full_name' => 'Saint Vincent and the Grenadines',
                'capital' => 'Kingstown',
                'code' => 'vc',
                'code_alpha3' => 'vag',
                'code_numeric' => 670,
                'emoji' => '🇻🇨',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.vc',
                'callingcode' => '1784',
            ),
            112 => 
            array (
                'id' => 113,
                'continent_id' => 6,
                'name' => 'Honduras',
                'full_name' => 'Republic of Honduras',
                'capital' => 'Tegucigalpa',
                'code' => 'hn',
                'code_alpha3' => 'hnd',
                'code_numeric' => 340,
                'emoji' => '🇭🇳',
                'has_division' => 0,
                'currency_code' => 'HNL',
                'currency_name' => 'Lempira',
                'tld' => '.hn',
                'callingcode' => '504',
            ),
            113 => 
            array (
                'id' => 114,
                'continent_id' => 6,
                'name' => 'Guatemala',
                'full_name' => 'The Republic of Guatemala',
                'capital' => 'Guatemala City',
                'code' => 'gt',
                'code_alpha3' => 'gtm',
                'code_numeric' => 320,
                'emoji' => '🇬🇹',
                'has_division' => 0,
                'currency_code' => 'GTQ',
                'currency_name' => 'Quetzal',
                'tld' => '.gt',
                'callingcode' => '502',
            ),
            114 => 
            array (
                'id' => 115,
                'continent_id' => 1,
                'name' => 'Georgia',
                'full_name' => 'Georgia',
                'capital' => 'Tbilisi',
                'code' => 'ge',
                'code_alpha3' => 'geo',
                'code_numeric' => 268,
                'emoji' => '🇬🇪',
                'has_division' => 0,
                'currency_code' => 'GEL',
                'currency_name' => 'Lari',
                'tld' => '.ge',
                'callingcode' => '995',
            ),
            115 => 
            array (
                'id' => 116,
                'continent_id' => 1,
                'name' => 'Armenia',
                'full_name' => 'The Republic of Armenia',
                'capital' => 'Yerevan',
                'code' => 'am',
                'code_alpha3' => 'arm',
                'code_numeric' => 51,
                'emoji' => '🇦🇲',
                'has_division' => 0,
                'currency_code' => 'AMD',
                'currency_name' => 'Armenian Dram',
                'tld' => '.am',
                'callingcode' => '374',
            ),
            116 => 
            array (
                'id' => 117,
                'continent_id' => 1,
                'name' => 'Azerbaijan',
                'full_name' => 'The Republic of Azerbaijan',
                'capital' => 'Baku',
                'code' => 'az',
                'code_alpha3' => 'aze',
                'code_numeric' => 31,
                'emoji' => '🇦🇿',
                'has_division' => 0,
                'currency_code' => 'AZN',
                'currency_name' => 'Azerbaijanian Manat',
                'tld' => '.az',
                'callingcode' => '994',
            ),
            117 => 
            array (
                'id' => 118,
                'continent_id' => 2,
                'name' => 'Belarus',
                'full_name' => 'The Republic of Belarus',
                'capital' => 'Minsk',
                'code' => 'by',
                'code_alpha3' => 'blr',
                'code_numeric' => 112,
                'emoji' => '🇧🇾',
                'has_division' => 0,
                'currency_code' => 'BYR',
                'currency_name' => 'Belarussian Ruble',
                'tld' => '.by',
                'callingcode' => '375',
            ),
            118 => 
            array (
                'id' => 119,
                'continent_id' => 2,
                'name' => 'Russia',
                'full_name' => 'Russian Federation',
                'capital' => 'Moscow',
                'code' => 'ru',
                'code_alpha3' => 'rus',
                'code_numeric' => 643,
                'emoji' => '🇷🇺',
                'has_division' => 0,
                'currency_code' => 'RUB',
                'currency_name' => 'Russian Ruble',
                'tld' => '.ru',
                'callingcode' => '70',
            ),
            119 => 
            array (
                'id' => 120,
                'continent_id' => 2,
                'name' => 'Ukraine',
                'full_name' => 'Ukraine',
                'capital' => 'Kyiv',
                'code' => 'ua',
                'code_alpha3' => 'ukr',
                'code_numeric' => 804,
                'emoji' => '🇺🇦',
                'has_division' => 0,
                'currency_code' => 'UAH',
                'currency_name' => 'Hryvnia',
                'tld' => '.ua',
                'callingcode' => '380',
            ),
            120 => 
            array (
                'id' => 121,
                'continent_id' => 2,
                'name' => 'Hungary',
                'full_name' => 'Hungary',
                'capital' => 'Budapest',
                'code' => 'hu',
                'code_alpha3' => 'hun',
                'code_numeric' => 348,
                'emoji' => '🇭🇺',
                'has_division' => 0,
                'currency_code' => 'HUF',
                'currency_name' => 'Forint',
                'tld' => '.hu',
                'callingcode' => '36',
            ),
            121 => 
            array (
                'id' => 122,
                'continent_id' => 2,
                'name' => 'Iceland',
                'full_name' => 'The Republic of Iceland',
                'capital' => 'Reykjavik',
                'code' => 'is',
                'code_alpha3' => 'isl',
                'code_numeric' => 352,
                'emoji' => '🇮🇸',
                'has_division' => 0,
                'currency_code' => 'ISK',
                'currency_name' => 'Iceland Krona',
                'tld' => '.is',
                'callingcode' => '354',
            ),
            122 => 
            array (
                'id' => 123,
                'continent_id' => 2,
                'name' => 'Malta',
                'full_name' => 'Republic of Malta',
                'capital' => 'Valletta',
                'code' => 'mt',
                'code_alpha3' => 'mlt',
                'code_numeric' => 470,
                'emoji' => '🇲🇹',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.mt',
                'callingcode' => '356',
            ),
            123 => 
            array (
                'id' => 124,
                'continent_id' => 2,
                'name' => 'Monaco',
                'full_name' => 'The Principality of Monaco',
                'capital' => 'Monaco',
                'code' => 'mc',
                'code_alpha3' => 'mco',
                'code_numeric' => 492,
                'emoji' => '🇲🇨',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.mc',
                'callingcode' => '377',
            ),
            124 => 
            array (
                'id' => 125,
                'continent_id' => 2,
                'name' => 'Norway',
                'full_name' => 'The Kingdom of Norway',
                'capital' => 'Oslo',
                'code' => 'no',
                'code_alpha3' => 'nor',
                'code_numeric' => 578,
                'emoji' => '🇳🇴',
                'has_division' => 0,
                'currency_code' => 'NOK',
                'currency_name' => 'Norwegian Krone',
                'tld' => '.no',
                'callingcode' => '47',
            ),
            125 => 
            array (
                'id' => 126,
                'continent_id' => 2,
                'name' => 'Romania',
                'full_name' => 'Romania',
                'capital' => 'Bucharest',
                'code' => 'ro',
                'code_alpha3' => 'rom',
                'code_numeric' => 642,
                'emoji' => '🇷🇴',
                'has_division' => 0,
                'currency_code' => 'RON',
                'currency_name' => 'New Romanian Leu',
                'tld' => '.ro',
                'callingcode' => '40',
            ),
            126 => 
            array (
                'id' => 127,
                'continent_id' => 2,
                'name' => 'San Marino',
                'full_name' => 'The Republic of San Marino',
                'capital' => 'City of San Marino',
                'code' => 'sm',
                'code_alpha3' => 'smr',
                'code_numeric' => 674,
                'emoji' => '🇸🇲',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.sm',
                'callingcode' => '378',
            ),
            127 => 
            array (
                'id' => 128,
                'continent_id' => 2,
                'name' => 'Sweden',
                'full_name' => 'The Kingdom of Sweden',
                'capital' => 'Stockholm',
                'code' => 'se',
                'code_alpha3' => 'swe',
                'code_numeric' => 752,
                'emoji' => '🇸🇪',
                'has_division' => 1,
                'currency_code' => 'SEK',
                'currency_name' => 'Swedish Krona',
                'tld' => '.se',
                'callingcode' => '46',
            ),
            128 => 
            array (
                'id' => 129,
                'continent_id' => 2,
                'name' => 'Switzerland',
                'full_name' => 'Swiss Confederation',
                'capital' => 'Bern',
                'code' => 'ch',
                'code_alpha3' => 'che',
                'code_numeric' => 756,
                'emoji' => '🇨🇭',
                'has_division' => 0,
                'currency_code' => 'CHE',
            'currency_name' => 'WIR Euro (complementary currency)',
                'tld' => '.ch',
                'callingcode' => '41',
            ),
            129 => 
            array (
                'id' => 130,
                'continent_id' => 2,
                'name' => 'Estonia',
                'full_name' => 'Republic of Estonia',
                'capital' => 'Tallinn',
                'code' => 'ee',
                'code_alpha3' => 'est',
                'code_numeric' => 233,
                'emoji' => '🇪🇪',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.ee',
                'callingcode' => '372',
            ),
            130 => 
            array (
                'id' => 131,
                'continent_id' => 2,
                'name' => 'Latvia',
                'full_name' => 'Republic of Latvia',
                'capital' => 'Riga',
                'code' => 'lv',
                'code_alpha3' => 'lva',
                'code_numeric' => 428,
                'emoji' => '🇱🇻',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.lv',
                'callingcode' => '371',
            ),
            131 => 
            array (
                'id' => 132,
                'continent_id' => 2,
                'name' => 'Lithuania',
                'full_name' => 'The Republic of Lithuania',
                'capital' => 'Vilnius',
                'code' => 'lt',
                'code_alpha3' => 'ltu',
                'code_numeric' => 440,
                'emoji' => '🇱🇹',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.lt',
                'callingcode' => '370',
            ),
            132 => 
            array (
                'id' => 133,
                'continent_id' => 2,
                'name' => 'Moldova',
                'full_name' => 'The Republic of Moldova',
                'capital' => 'Chișinău',
                'code' => 'md',
                'code_alpha3' => 'mda',
                'code_numeric' => 498,
                'emoji' => '🇲🇩',
                'has_division' => 0,
                'currency_code' => 'MDL',
                'currency_name' => 'Moldovan leu',
                'tld' => '.md',
                'callingcode' => '373',
            ),
            133 => 
            array (
                'id' => 134,
                'continent_id' => 1,
                'name' => 'Turkey',
                'full_name' => 'The Republic of Turkey',
                'capital' => 'Ankara',
                'code' => 'tr',
                'code_alpha3' => 'tur',
                'code_numeric' => 792,
                'emoji' => '🇹🇷',
                'has_division' => 0,
                'currency_code' => 'TRY',
                'currency_name' => 'Turkish Lira',
                'tld' => '.tr',
                'callingcode' => '90',
            ),
            134 => 
            array (
                'id' => 135,
                'continent_id' => 2,
                'name' => 'Slovenia',
                'full_name' => 'The Republic of Slovenia',
                'capital' => 'Ljubljana',
                'code' => 'si',
                'code_alpha3' => 'svn',
                'code_numeric' => 705,
                'emoji' => '🇸🇮',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.si',
                'callingcode' => '386',
            ),
            135 => 
            array (
                'id' => 136,
                'continent_id' => 2,
                'name' => 'Czech',
                'full_name' => 'The Czech Republic',
                'capital' => 'Prague',
                'code' => 'cz',
                'code_alpha3' => 'cze',
                'code_numeric' => 203,
                'emoji' => '🇨🇿',
                'has_division' => 0,
                'currency_code' => 'CZK',
                'currency_name' => 'Czech Koruna',
                'tld' => '.cz',
                'callingcode' => '420',
            ),
            136 => 
            array (
                'id' => 137,
                'continent_id' => 2,
                'name' => 'Slovakia',
                'full_name' => 'Slovak Republic',
                'capital' => 'Bratislava',
                'code' => 'sk',
                'code_alpha3' => 'svk',
                'code_numeric' => 703,
                'emoji' => '🇸🇰',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.sk',
                'callingcode' => '421',
            ),
            137 => 
            array (
                'id' => 138,
                'continent_id' => 2,
                'name' => 'North Macedonia',
                'full_name' => 'Republic of North Macedonia',
                'capital' => 'Skopje',
                'code' => 'mk',
                'code_alpha3' => 'mkd',
                'code_numeric' => 807,
                'emoji' => '🇲🇰',
                'has_division' => 0,
                'currency_code' => 'MKD',
                'currency_name' => 'Macedonian denar',
                'tld' => '.mk',
                'callingcode' => '389',
            ),
            138 => 
            array (
                'id' => 139,
                'continent_id' => 2,
                'name' => 'Bosnia Herzegovina',
                'full_name' => 'Bosnia and Herzegovina',
                'capital' => 'Sarajevo',
                'code' => 'ba',
                'code_alpha3' => 'bih',
                'code_numeric' => 70,
                'emoji' => '🇧🇦',
                'has_division' => 0,
                'currency_code' => 'BAM',
                'currency_name' => 'Convertible Mark',
                'tld' => '.ba',
                'callingcode' => '387',
            ),
            139 => 
            array (
                'id' => 140,
                'continent_id' => 2,
                'name' => 'Vatican City State',
                'full_name' => 'Vatican City State',
                'capital' => 'Vatican City',
                'code' => 'va',
                'code_alpha3' => 'vat',
                'code_numeric' => 336,
                'emoji' => '🇻🇦',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.va',
                'callingcode' => '39',
            ),
            140 => 
            array (
                'id' => 141,
                'continent_id' => 2,
                'name' => 'Netherlands',
                'full_name' => 'The Kingdom of Netherlands',
                'capital' => 'Amsterdam',
                'code' => 'nl',
                'code_alpha3' => 'nld',
                'code_numeric' => 528,
                'emoji' => '🇳🇱',
                'has_division' => 1,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.nl',
                'callingcode' => '31',
            ),
            141 => 
            array (
                'id' => 142,
                'continent_id' => 2,
                'name' => 'Croatia',
                'full_name' => 'The Republic of Croatia',
                'capital' => 'Zagreb',
                'code' => 'hr',
                'code_alpha3' => 'hrv',
                'code_numeric' => 191,
                'emoji' => '🇭🇷',
                'has_division' => 0,
                'currency_code' => 'HRK',
                'currency_name' => 'Croatian Kuna',
                'tld' => '.hr',
                'callingcode' => '385',
            ),
            142 => 
            array (
                'id' => 143,
                'continent_id' => 2,
                'name' => 'Greece',
                'full_name' => 'The Hellenic Republic',
                'capital' => 'Athens',
                'code' => 'gr',
                'code_alpha3' => 'grc',
                'code_numeric' => 300,
                'emoji' => '🇬🇷',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.gr',
                'callingcode' => '30',
            ),
            143 => 
            array (
                'id' => 144,
                'continent_id' => 2,
                'name' => 'Ireland',
                'full_name' => 'The Republic of Ireland',
                'capital' => 'Dublin',
                'code' => 'ie',
                'code_alpha3' => 'irl',
                'code_numeric' => 372,
                'emoji' => '🇮🇪',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.ie',
                'callingcode' => '353',
            ),
            144 => 
            array (
                'id' => 145,
                'continent_id' => 2,
                'name' => 'Belgium',
                'full_name' => 'The Kingdom Of Belgium',
                'capital' => 'Brussels',
                'code' => 'be',
                'code_alpha3' => 'bel',
                'code_numeric' => 56,
                'emoji' => '🇧🇪',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.be',
                'callingcode' => '32',
            ),
            145 => 
            array (
                'id' => 146,
                'continent_id' => 1,
                'name' => 'Cyprus',
                'full_name' => 'Republic of Cyprus',
                'capital' => 'Nicosia',
                'code' => 'cy',
                'code_alpha3' => 'cyp',
                'code_numeric' => 196,
                'emoji' => '🇨🇾',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.cy',
                'callingcode' => '357',
            ),
            146 => 
            array (
                'id' => 147,
                'continent_id' => 2,
                'name' => 'Denmark',
                'full_name' => 'The Kingdom of Denmark',
                'capital' => 'Copenhagen',
                'code' => 'dk',
                'code_alpha3' => 'dnk',
                'code_numeric' => 208,
                'emoji' => '🇩🇰',
                'has_division' => 0,
                'currency_code' => 'DKK',
                'currency_name' => 'Danish Krone',
                'tld' => '.dk',
                'callingcode' => '45',
            ),
            147 => 
            array (
                'id' => 148,
                'continent_id' => 2,
                'name' => 'United Kingdom',
                'full_name' => 'United Kingdom of Great Britain and Northern Ireland',
                'capital' => 'London',
                'code' => 'gb',
                'code_alpha3' => 'eng',
                'code_numeric' => 826,
                'emoji' => '🇬🇧',
                'has_division' => 1,
                'currency_code' => 'GBP',
                'currency_name' => 'Pound sterling',
                'tld' => '.uk',
                'callingcode' => '44',
            ),
            148 => 
            array (
                'id' => 149,
                'continent_id' => 2,
                'name' => 'Germany',
                'full_name' => 'The Federal Republic of Germany',
                'capital' => 'Berlin',
                'code' => 'de',
                'code_alpha3' => 'deu',
                'code_numeric' => 276,
                'emoji' => '🇩🇪',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.de',
                'callingcode' => '49',
            ),
            149 => 
            array (
                'id' => 150,
                'continent_id' => 2,
                'name' => 'France',
                'full_name' => 'The French Republic',
                'capital' => 'Paris',
                'code' => 'fr',
                'code_alpha3' => 'fra',
                'code_numeric' => 250,
                'emoji' => '🇫🇷',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.fr',
                'callingcode' => '33',
            ),
            150 => 
            array (
                'id' => 151,
                'continent_id' => 2,
                'name' => 'Italy',
                'full_name' => 'The Republic of Italy',
                'capital' => 'Rome',
                'code' => 'it',
                'code_alpha3' => 'ita',
                'code_numeric' => 380,
                'emoji' => '🇮🇹',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.it',
                'callingcode' => '39',
            ),
            151 => 
            array (
                'id' => 152,
                'continent_id' => 2,
                'name' => 'Luxembourg',
                'full_name' => 'The Grand Duchy of Luxembourg',
                'capital' => 'Luxembourg',
                'code' => 'lu',
                'code_alpha3' => 'lux',
                'code_numeric' => 442,
                'emoji' => '🇱🇺',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.lu',
                'callingcode' => '352',
            ),
            152 => 
            array (
                'id' => 153,
                'continent_id' => 2,
                'name' => 'Portugal',
                'full_name' => 'Portugal,the Portuguese Republic',
                'capital' => 'Lisbon',
                'code' => 'pt',
                'code_alpha3' => 'prt',
                'code_numeric' => 620,
                'emoji' => '🇵🇹',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.pt',
                'callingcode' => '351',
            ),
            153 => 
            array (
                'id' => 154,
                'continent_id' => 2,
                'name' => 'Poland',
                'full_name' => 'The Republic of Poland',
                'capital' => 'Warsaw',
                'code' => 'pl',
                'code_alpha3' => 'pol',
                'code_numeric' => 616,
                'emoji' => '🇵🇱',
                'has_division' => 1,
                'currency_code' => 'PLN',
                'currency_name' => 'Zloty',
                'tld' => '.pl',
                'callingcode' => '48',
            ),
            154 => 
            array (
                'id' => 155,
                'continent_id' => 2,
                'name' => 'Spain',
                'full_name' => 'The Kingdom of Spain',
                'capital' => 'Madrid',
                'code' => 'es',
                'code_alpha3' => 'esp',
                'code_numeric' => 724,
                'emoji' => '🇪🇸',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.es',
                'callingcode' => '34',
            ),
            155 => 
            array (
                'id' => 156,
                'continent_id' => 2,
                'name' => 'Albania',
                'full_name' => 'The Republic of Albania',
                'capital' => 'Tirana',
                'code' => 'al',
                'code_alpha3' => 'alb',
                'code_numeric' => 8,
                'emoji' => '🇦🇱',
                'has_division' => 0,
                'currency_code' => 'ALL',
                'currency_name' => 'Lek',
                'tld' => '.al',
                'callingcode' => '355',
            ),
            156 => 
            array (
                'id' => 157,
                'continent_id' => 2,
                'name' => 'Andorra',
                'full_name' => 'The Principality of Andorra',
                'capital' => 'Andorra la Vella',
                'code' => 'ad',
                'code_alpha3' => 'and',
                'code_numeric' => 20,
                'emoji' => '🇦🇩',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.ad',
                'callingcode' => '376',
            ),
            157 => 
            array (
                'id' => 158,
                'continent_id' => 2,
                'name' => 'Liechtenstein',
                'full_name' => 'Principality of Liechtenstein',
                'capital' => 'Vaduz',
                'code' => 'li',
                'code_alpha3' => 'lie',
                'code_numeric' => 438,
                'emoji' => '🇱🇮',
                'has_division' => 0,
                'currency_code' => 'CHF',
                'currency_name' => 'Swiss Franc',
                'tld' => '.li',
                'callingcode' => '423',
            ),
            158 => 
            array (
                'id' => 159,
                'continent_id' => 2,
                'name' => 'Serbia',
                'full_name' => 'Republic of Serbia',
                'capital' => 'Belgrade',
                'code' => 'rs',
                'code_alpha3' => 'srb',
                'code_numeric' => 688,
                'emoji' => '🇷🇸',
                'has_division' => 0,
                'currency_code' => 'RSD',
                'currency_name' => 'Serbian Dinar',
                'tld' => '.rs',
                'callingcode' => '381',
            ),
            159 => 
            array (
                'id' => 160,
                'continent_id' => 2,
                'name' => 'Austria',
                'full_name' => 'The Republic Of Austria',
                'capital' => 'Vienna',
                'code' => 'at',
                'code_alpha3' => 'aut',
                'code_numeric' => 40,
                'emoji' => '🇦🇹',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.at',
                'callingcode' => '43',
            ),
            160 => 
            array (
                'id' => 161,
                'continent_id' => 2,
                'name' => 'Bulgaria',
                'full_name' => 'The Republic of Bulgaria',
                'capital' => 'Sofia',
                'code' => 'bg',
                'code_alpha3' => 'bgr',
                'code_numeric' => 100,
                'emoji' => '🇧🇬',
                'has_division' => 0,
                'currency_code' => 'BGN',
                'currency_name' => 'Bulgarian Lev',
                'tld' => '.bg',
                'callingcode' => '359',
            ),
            161 => 
            array (
                'id' => 162,
                'continent_id' => 2,
                'name' => 'Finland',
                'full_name' => 'The Republic of Finland',
                'capital' => 'Helsinki',
                'code' => 'fi',
                'code_alpha3' => 'fin',
                'code_numeric' => 246,
                'emoji' => '🇫🇮',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.fi',
                'callingcode' => '358',
            ),
            162 => 
            array (
                'id' => 163,
                'continent_id' => 2,
                'name' => 'Gibraltar',
                'full_name' => 'Gibraltar',
                'capital' => 'Gibraltar',
                'code' => 'gi',
                'code_alpha3' => 'gib',
                'code_numeric' => 292,
                'emoji' => '🇬🇮',
                'has_division' => 0,
                'currency_code' => 'GIP',
                'currency_name' => 'Gibraltar Pound',
                'tld' => '.gi',
                'callingcode' => '350',
            ),
            163 => 
            array (
                'id' => 164,
                'continent_id' => 6,
                'name' => 'Dominica',
                'full_name' => 'The Commonwealth of Dominica',
                'capital' => 'Roseau',
                'code' => 'dm',
                'code_alpha3' => 'dma',
                'code_numeric' => 212,
                'emoji' => '🇩🇲',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.dm',
                'callingcode' => '1767',
            ),
            164 => 
            array (
                'id' => 165,
                'continent_id' => 6,
                'name' => 'Bermuda',
                'full_name' => 'Bermuda',
                'capital' => 'Hamilton',
                'code' => 'bm',
                'code_alpha3' => 'bmu',
                'code_numeric' => 60,
                'emoji' => '🇧🇲',
                'has_division' => 0,
                'currency_code' => 'BMD',
                'currency_name' => 'Bermudian Dollar',
                'tld' => '.bm',
                'callingcode' => '1441',
            ),
            165 => 
            array (
                'id' => 166,
                'continent_id' => 6,
                'name' => 'Canada',
                'full_name' => 'Canada',
                'capital' => 'Ottawa',
                'code' => 'ca',
                'code_alpha3' => 'can',
                'code_numeric' => 124,
                'emoji' => '🇨🇦',
                'has_division' => 1,
                'currency_code' => 'CAD',
                'currency_name' => 'Canadian Dollar',
                'tld' => '.ca',
                'callingcode' => '1',
            ),
            166 => 
            array (
                'id' => 167,
                'continent_id' => 6,
                'name' => 'United States',
                'full_name' => 'The United States of America',
                'capital' => 'Washington D.C.',
                'code' => 'us',
                'code_alpha3' => 'usa',
                'code_numeric' => 840,
                'emoji' => '🇺🇸',
                'has_division' => 1,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.us',
                'callingcode' => '1',
            ),
            167 => 
            array (
                'id' => 168,
                'continent_id' => 6,
                'name' => 'Greenland',
                'full_name' => 'Greenland',
                'capital' => 'Nuuk',
                'code' => 'gl',
                'code_alpha3' => 'grl',
                'code_numeric' => 304,
                'emoji' => '🇬🇱',
                'has_division' => 0,
                'currency_code' => 'DKK',
                'currency_name' => 'Danish Krone',
                'tld' => '.gl',
                'callingcode' => '299',
            ),
            168 => 
            array (
                'id' => 169,
                'continent_id' => 4,
                'name' => 'Tonga',
                'full_name' => 'The Kingdom of Tonga',
                'capital' => 'Nuku\'alofa',
                'code' => 'to',
                'code_alpha3' => 'ton',
                'code_numeric' => 776,
                'emoji' => '🇹🇴',
                'has_division' => 0,
                'currency_code' => 'TOP',
                'currency_name' => 'Pa’anga',
                'tld' => '.to',
                'callingcode' => '676',
            ),
            169 => 
            array (
                'id' => 170,
                'continent_id' => 4,
                'name' => 'Australia',
                'full_name' => 'The Commonwealth of Australia',
                'capital' => 'Canberra',
                'code' => 'au',
                'code_alpha3' => 'aus',
                'code_numeric' => 36,
                'emoji' => '🇦🇺',
                'has_division' => 1,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'tld' => '.au',
                'callingcode' => '61',
            ),
            170 => 
            array (
                'id' => 171,
                'continent_id' => 4,
                'name' => 'Cook Islands',
                'full_name' => 'The Cook Islands',
                'capital' => 'Avarua',
                'code' => 'ck',
                'code_alpha3' => 'cok',
                'code_numeric' => 184,
                'emoji' => '🇨🇰',
                'has_division' => 0,
                'currency_code' => 'NZD',
                'currency_name' => 'New Zealand Dollar',
                'tld' => '.ck',
                'callingcode' => '682',
            ),
            171 => 
            array (
                'id' => 172,
                'continent_id' => 4,
                'name' => 'Nauru',
                'full_name' => 'The Republic of Nauru',
                'capital' => 'Yaren',
                'code' => 'nr',
                'code_alpha3' => 'nru',
                'code_numeric' => 520,
                'emoji' => '🇳🇷',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'tld' => '.nr',
                'callingcode' => '674',
            ),
            172 => 
            array (
                'id' => 173,
                'continent_id' => 4,
                'name' => 'New Caledonia',
                'full_name' => 'New Caledonia',
                'capital' => 'Nouméa',
                'code' => 'nc',
                'code_alpha3' => 'ncl',
                'code_numeric' => 540,
                'emoji' => '🇳🇨',
                'has_division' => 0,
                'currency_code' => 'XPF',
                'currency_name' => 'CFP Franc',
                'tld' => '.nc',
                'callingcode' => '687',
            ),
            173 => 
            array (
                'id' => 174,
                'continent_id' => 4,
                'name' => 'Vanuatu',
                'full_name' => 'Republic of Vanuatu',
                'capital' => 'Port Vila',
                'code' => 'vu',
                'code_alpha3' => 'vut',
                'code_numeric' => 548,
                'emoji' => '🇻🇺',
                'has_division' => 0,
                'currency_code' => 'VUV',
                'currency_name' => 'Vatu',
                'tld' => '.vu',
                'callingcode' => '678',
            ),
            174 => 
            array (
                'id' => 175,
                'continent_id' => 4,
                'name' => 'Solomon Islands',
                'full_name' => 'Solomon Islands',
                'capital' => 'Honiara',
                'code' => 'sb',
                'code_alpha3' => 'slb',
                'code_numeric' => 90,
                'emoji' => '🇸🇧',
                'has_division' => 0,
                'currency_code' => 'SBD',
                'currency_name' => 'Solomon Islands Dollar',
                'tld' => '.sb',
                'callingcode' => '677',
            ),
            175 => 
            array (
                'id' => 176,
                'continent_id' => 4,
                'name' => 'Samoa',
                'full_name' => 'The Independent State of Samoa',
                'capital' => 'Apia',
                'code' => 'ws',
                'code_alpha3' => 'wsm',
                'code_numeric' => 882,
                'emoji' => '🇼🇸',
                'has_division' => 0,
                'currency_code' => 'WST',
                'currency_name' => 'Tala',
                'tld' => '.ws',
                'callingcode' => '685',
            ),
            176 => 
            array (
                'id' => 177,
                'continent_id' => 4,
                'name' => 'Tuvalu',
                'full_name' => 'Tuvalu',
                'capital' => 'Funafuti',
                'code' => 'tv',
                'code_alpha3' => 'tuv',
                'code_numeric' => 798,
                'emoji' => '🇹🇻',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'tld' => '.tv',
                'callingcode' => '688',
            ),
            177 => 
            array (
                'id' => 178,
                'continent_id' => 4,
                'name' => 'Micronesia',
                'full_name' => 'Federated States of Micronesia',
                'capital' => 'Palikir',
                'code' => 'fm',
                'code_alpha3' => 'fsm',
                'code_numeric' => 583,
                'emoji' => '🇫🇲',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.fm',
                'callingcode' => '691',
            ),
            178 => 
            array (
                'id' => 179,
                'continent_id' => 4,
                'name' => 'Marshall Islands',
                'full_name' => 'Republic of the Marshall Islands',
                'capital' => 'Majuro',
                'code' => 'mh',
                'code_alpha3' => 'mhl',
                'code_numeric' => 584,
                'emoji' => '🇲🇭',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.mh',
                'callingcode' => '692',
            ),
            179 => 
            array (
                'id' => 180,
                'continent_id' => 4,
                'name' => 'Kiribati',
                'full_name' => 'The Republic of Kiribati',
                'capital' => 'South Tarawa',
                'code' => 'ki',
                'code_alpha3' => 'kir',
                'code_numeric' => 296,
                'emoji' => '🇰🇮',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'tld' => '.ki',
                'callingcode' => '686',
            ),
            180 => 
            array (
                'id' => 181,
                'continent_id' => 4,
                'name' => 'French Polynesia',
                'full_name' => 'French Polynesia',
                'capital' => 'Papeetē',
                'code' => 'pf',
                'code_alpha3' => 'pyf',
                'code_numeric' => 258,
                'emoji' => '🇵🇫',
                'has_division' => 0,
                'currency_code' => 'XPF',
                'currency_name' => 'CFP Franc',
                'tld' => '.pf',
                'callingcode' => '689',
            ),
            181 => 
            array (
                'id' => 182,
                'continent_id' => 4,
                'name' => 'New Zealand',
                'full_name' => 'New Zealand',
                'capital' => 'Wellington',
                'code' => 'nz',
                'code_alpha3' => 'nzl',
                'code_numeric' => 554,
                'emoji' => '🇳🇿',
                'has_division' => 0,
                'currency_code' => 'NZD',
                'currency_name' => 'New Zealand Dollar',
                'tld' => '.nz',
                'callingcode' => '64',
            ),
            182 => 
            array (
                'id' => 183,
                'continent_id' => 4,
                'name' => 'Fiji',
                'full_name' => 'The Republic of Fiji',
                'capital' => 'Suva',
                'code' => 'fj',
                'code_alpha3' => 'fji',
                'code_numeric' => 242,
                'emoji' => '🇫🇯',
                'has_division' => 0,
                'currency_code' => 'FJD',
                'currency_name' => 'Fiji Dollar',
                'tld' => '.fj',
                'callingcode' => '679',
            ),
            183 => 
            array (
                'id' => 184,
                'continent_id' => 4,
                'name' => 'Papua New Guinea',
                'full_name' => 'The Independent State of Papua New Guinea',
                'capital' => 'Port Moresby',
                'code' => 'pg',
                'code_alpha3' => 'png',
                'code_numeric' => 598,
                'emoji' => '🇵🇬',
                'has_division' => 0,
                'currency_code' => 'PGK',
                'currency_name' => 'Kina',
                'tld' => '.pg',
                'callingcode' => '675',
            ),
            184 => 
            array (
                'id' => 185,
                'continent_id' => 4,
                'name' => 'Palau',
                'full_name' => 'The Republic of Palau',
                'capital' => 'Ngerulmud',
                'code' => 'pw',
                'code_alpha3' => 'plw',
                'code_numeric' => 585,
                'emoji' => '🇵🇼',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.pw',
                'callingcode' => '680',
            ),
            185 => 
            array (
                'id' => 186,
                'continent_id' => 7,
                'name' => 'Chile',
                'full_name' => 'Republic of Chile',
                'capital' => 'Santiago',
                'code' => 'cl',
                'code_alpha3' => 'chl',
                'code_numeric' => 152,
                'emoji' => '🇨🇱',
                'has_division' => 0,
                'currency_code' => 'CLP',
                'currency_name' => 'Chilean Peso',
                'tld' => '.cl',
                'callingcode' => '56',
            ),
            186 => 
            array (
                'id' => 187,
                'continent_id' => 7,
                'name' => 'Colombia',
                'full_name' => 'The Republic of Colombia',
                'capital' => 'Bogotá',
                'code' => 'co',
                'code_alpha3' => 'col',
                'code_numeric' => 170,
                'emoji' => '🇨🇴',
                'has_division' => 0,
                'currency_code' => 'COP',
                'currency_name' => 'Colombian Peso',
                'tld' => '.co',
                'callingcode' => '57',
            ),
            187 => 
            array (
                'id' => 188,
                'continent_id' => 7,
                'name' => 'Guyana',
                'full_name' => 'The Republic of Guyana',
                'capital' => 'Georgetown',
                'code' => 'gy',
                'code_alpha3' => 'guy',
                'code_numeric' => 328,
                'emoji' => '🇬🇾',
                'has_division' => 0,
                'currency_code' => 'GYD',
                'currency_name' => 'Guyana Dollar',
                'tld' => '.gy',
                'callingcode' => '592',
            ),
            188 => 
            array (
                'id' => 189,
                'continent_id' => 7,
                'name' => 'Paraguay',
                'full_name' => 'The Republic of Paraguay',
                'capital' => 'Asunción',
                'code' => 'py',
                'code_alpha3' => 'pry',
                'code_numeric' => 600,
                'emoji' => '🇵🇾',
                'has_division' => 0,
                'currency_code' => 'PYG',
                'currency_name' => 'Guarani',
                'tld' => '.py',
                'callingcode' => '595',
            ),
            189 => 
            array (
                'id' => 190,
                'continent_id' => 7,
                'name' => 'Peru',
                'full_name' => 'The Republic of Peru',
                'capital' => 'Lima',
                'code' => 'pe',
                'code_alpha3' => 'per',
                'code_numeric' => 604,
                'emoji' => '🇵🇪',
                'has_division' => 0,
                'currency_code' => 'PEN',
                'currency_name' => 'Nuevo Sol',
                'tld' => '.pe',
                'callingcode' => '51',
            ),
            190 => 
            array (
                'id' => 191,
                'continent_id' => 7,
                'name' => 'Suriname',
                'full_name' => 'The Republic of Suriname',
                'capital' => 'Paramaribo',
                'code' => 'sr',
                'code_alpha3' => 'sur',
                'code_numeric' => 740,
                'emoji' => '🇸🇷',
                'has_division' => 0,
                'currency_code' => 'SRD',
                'currency_name' => 'Surinam Dollar',
                'tld' => '.sr',
                'callingcode' => '597',
            ),
            191 => 
            array (
                'id' => 192,
                'continent_id' => 7,
                'name' => 'Venezuela',
                'full_name' => 'Bolivarian Republic of Venezuela',
                'capital' => 'Caracas',
                'code' => 've',
                'code_alpha3' => 'ven',
                'code_numeric' => 862,
                'emoji' => '🇻🇪',
                'has_division' => 0,
                'currency_code' => 'VEF',
                'currency_name' => 'Venezuelan bolívar',
                'tld' => '.ve',
                'callingcode' => '58',
            ),
            192 => 
            array (
                'id' => 193,
                'continent_id' => 7,
                'name' => 'Uruguay',
                'full_name' => 'The Oriental Republic of Uruguay',
                'capital' => 'Montevideo',
                'code' => 'uy',
                'code_alpha3' => 'ury',
                'code_numeric' => 858,
                'emoji' => '🇺🇾',
                'has_division' => 0,
                'currency_code' => 'UYU',
                'currency_name' => 'Peso Uruguayo',
                'tld' => '.uy',
                'callingcode' => '598',
            ),
            193 => 
            array (
                'id' => 194,
                'continent_id' => 7,
                'name' => 'Ecuador',
                'full_name' => 'The Republic of Ecuador',
                'capital' => 'Quito',
                'code' => 'ec',
                'code_alpha3' => 'ecu',
                'code_numeric' => 218,
                'emoji' => '🇪🇨',
                'has_division' => 1,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.ec',
                'callingcode' => '593',
            ),
            194 => 
            array (
                'id' => 195,
                'continent_id' => 7,
                'name' => 'Antigua and Barbuda',
                'full_name' => 'Antigua and Barbuda',
                'capital' => 'Saint John\'s',
                'code' => 'ag',
                'code_alpha3' => 'atg',
                'code_numeric' => 28,
                'emoji' => '🇦🇬',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.ag',
                'callingcode' => '1268',
            ),
            195 => 
            array (
                'id' => 196,
                'continent_id' => 7,
                'name' => 'Aruba',
                'full_name' => 'Aruba',
                'capital' => 'Oranjestad',
                'code' => 'aw',
                'code_alpha3' => 'abw',
                'code_numeric' => 533,
                'emoji' => '🇦🇼',
                'has_division' => 0,
                'currency_code' => 'AWG',
                'currency_name' => 'Aruban Florin',
                'tld' => '.aw',
                'callingcode' => '297',
            ),
            196 => 
            array (
                'id' => 197,
                'continent_id' => 7,
                'name' => 'Bahamas',
                'full_name' => 'The Commonwealth of The Bahamas',
                'capital' => 'Nassau',
                'code' => 'bs',
                'code_alpha3' => 'bhs',
                'code_numeric' => 44,
                'emoji' => '🇧🇸',
                'has_division' => 0,
                'currency_code' => 'BSD',
                'currency_name' => 'Bahamian Dollar',
                'tld' => '.bs',
                'callingcode' => '1242',
            ),
            197 => 
            array (
                'id' => 198,
                'continent_id' => 7,
                'name' => 'Barbados',
                'full_name' => 'Barbados',
                'capital' => 'Bridgetown',
                'code' => 'bb',
                'code_alpha3' => 'brb',
                'code_numeric' => 52,
                'emoji' => '🇧🇧',
                'has_division' => 0,
                'currency_code' => 'BBD',
                'currency_name' => 'Barbados Dollar',
                'tld' => '.bb',
                'callingcode' => '1246',
            ),
            198 => 
            array (
                'id' => 199,
                'continent_id' => 7,
                'name' => 'Cayman Islands',
                'full_name' => 'Cayman Islands',
                'capital' => 'George Town',
                'code' => 'ky',
                'code_alpha3' => 'cym',
                'code_numeric' => 136,
                'emoji' => '🇰🇾',
                'has_division' => 0,
                'currency_code' => 'KYD',
                'currency_name' => 'Cayman Islands Dollar',
                'tld' => '.ky',
                'callingcode' => '1345',
            ),
            199 => 
            array (
                'id' => 200,
                'continent_id' => 7,
                'name' => 'Grenada',
                'full_name' => 'Grenada',
                'capital' => 'St. George\'s',
                'code' => 'gd',
                'code_alpha3' => 'grd',
                'code_numeric' => 308,
                'emoji' => '🇬🇩',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.gd',
                'callingcode' => '1473',
            ),
            200 => 
            array (
                'id' => 201,
                'continent_id' => 7,
                'name' => 'Haiti',
                'full_name' => 'The Republic of Haiti',
                'capital' => 'Port-au-Prince',
                'code' => 'ht',
                'code_alpha3' => 'hti',
                'code_numeric' => 332,
                'emoji' => '🇭🇹',
                'has_division' => 0,
                'currency_code' => 'HTG',
                'currency_name' => 'Haitian gourde',
                'tld' => '.ht',
                'callingcode' => '509',
            ),
            201 => 
            array (
                'id' => 202,
                'continent_id' => 7,
                'name' => 'Jamaica',
                'full_name' => 'Jamaica',
                'capital' => 'Kingston',
                'code' => 'jm',
                'code_alpha3' => 'jam',
                'code_numeric' => 388,
                'emoji' => '🇯🇲',
                'has_division' => 0,
                'currency_code' => 'JMD',
                'currency_name' => 'Jamaican Dollar',
                'tld' => '.jm',
                'callingcode' => '1876',
            ),
            202 => 
            array (
                'id' => 203,
                'continent_id' => 7,
                'name' => 'Martinique',
                'full_name' => 'Martinique',
                'capital' => 'Fort-de-France',
                'code' => 'mq',
                'code_alpha3' => 'mtq',
                'code_numeric' => 474,
                'emoji' => '🇲🇶',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.mq',
                'callingcode' => '596',
            ),
            203 => 
            array (
                'id' => 204,
                'continent_id' => 7,
                'name' => 'Montserrat',
                'full_name' => 'Montserrat',
                'capital' => 'Plymouth',
                'code' => 'ms',
                'code_alpha3' => 'msr',
                'code_numeric' => 500,
                'emoji' => '🇲🇸',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.ms',
                'callingcode' => '1664',
            ),
            204 => 
            array (
                'id' => 205,
                'continent_id' => 7,
                'name' => 'Trinidad and Tobago',
                'full_name' => 'Republic of Trinidad and Tobago',
                'capital' => 'Port of Spain',
                'code' => 'tt',
                'code_alpha3' => 'tto',
                'code_numeric' => 780,
                'emoji' => '🇹🇹',
                'has_division' => 0,
                'currency_code' => 'TTD',
                'currency_name' => 'Trinidad and Tobago Dollar',
                'tld' => '.tt',
                'callingcode' => '1868',
            ),
            205 => 
            array (
                'id' => 206,
                'continent_id' => 7,
                'name' => 'Saint Kitts and Nevis',
                'full_name' => 'Federation of Saint Christopher and Nevis',
                'capital' => 'Basseterre',
                'code' => 'kn',
                'code_alpha3' => 'kna',
                'code_numeric' => 659,
                'emoji' => '🇰🇳',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.kn',
                'callingcode' => '1869',
            ),
            206 => 
            array (
                'id' => 207,
                'continent_id' => 7,
                'name' => 'Saint Pierre and Miquelon',
                'full_name' => 'Saint Pierre and Miquelon',
                'capital' => 'Saint-Pierre',
                'code' => 'pm',
                'code_alpha3' => 'spm',
                'code_numeric' => 666,
                'emoji' => '🇵🇲',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.pm',
                'callingcode' => '508',
            ),
            207 => 
            array (
                'id' => 208,
                'continent_id' => 7,
                'name' => 'Argentina',
                'full_name' => 'The Republic of Argentina',
                'capital' => 'Buenos Aires',
                'code' => 'ar',
                'code_alpha3' => 'arg',
                'code_numeric' => 32,
                'emoji' => '🇦🇷',
                'has_division' => 0,
                'currency_code' => 'ARS',
                'currency_name' => 'Argentine Peso',
                'tld' => '.ar',
                'callingcode' => '54',
            ),
            208 => 
            array (
                'id' => 209,
                'continent_id' => 7,
                'name' => 'Belize',
                'full_name' => 'Belize',
                'capital' => 'Belmopan',
                'code' => 'bz',
                'code_alpha3' => 'blz',
                'code_numeric' => 84,
                'emoji' => '🇧🇿',
                'has_division' => 0,
                'currency_code' => 'BZD',
                'currency_name' => 'Belize Dollar',
                'tld' => '.bz',
                'callingcode' => '501',
            ),
            209 => 
            array (
                'id' => 210,
                'continent_id' => 7,
                'name' => 'Bolivia',
                'full_name' => 'The Republic of Bolivia',
                'capital' => 'Sucre',
                'code' => 'bo',
                'code_alpha3' => 'bol',
                'code_numeric' => 68,
                'emoji' => '🇧🇴',
                'has_division' => 0,
                'currency_code' => 'BOB',
                'currency_name' => 'Boliviano',
                'tld' => '.bo',
                'callingcode' => '591',
            ),
            210 => 
            array (
                'id' => 211,
                'continent_id' => 7,
                'name' => 'Brazil',
                'full_name' => 'The Federative Republic of Brazil',
                'capital' => 'Brasília',
                'code' => 'br',
                'code_alpha3' => 'bra',
                'code_numeric' => 76,
                'emoji' => '🇧🇷',
                'has_division' => 1,
                'currency_code' => 'BRL',
                'currency_name' => 'Brazilian Real',
                'tld' => '.br',
                'callingcode' => '55',
            ),
            211 => 
            array (
                'id' => 212,
                'continent_id' => 4,
                'name' => 'American Samoa',
                'full_name' => 'American Samoa',
                'capital' => 'Pago Pago',
                'code' => 'as',
                'code_alpha3' => 'asm',
                'code_numeric' => 16,
                'emoji' => '🇦🇸',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.as',
                'callingcode' => '1684',
            ),
            212 => 
            array (
                'id' => 213,
                'continent_id' => 2,
                'name' => 'Aland Islands',
                'full_name' => 'Aland Island,Ahvenanmaa',
                'capital' => 'Mariehamn',
                'code' => 'ax',
                'code_alpha3' => 'ala',
                'code_numeric' => 248,
                'emoji' => '🇦🇽',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.ax',
                'callingcode' => '358',
            ),
            213 => 
            array (
                'id' => 214,
                'continent_id' => 6,
                'name' => 'Saint Barthélemy',
                'full_name' => 'Collectivitéde Saint-Barthélemy',
                'capital' => 'Gustavia',
                'code' => 'bl',
                'code_alpha3' => 'blm',
                'code_numeric' => 652,
                'emoji' => '🇧🇱',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.bl',
                'callingcode' => '590',
            ),
            214 => 
            array (
                'id' => 215,
                'continent_id' => 6,
                'name' => 'Bonaire, Sint Eustatius and Saba',
                'full_name' => 'Bonaire, Sint Eustatius and Saba',
                'capital' => NULL,
                'code' => 'bq',
                'code_alpha3' => 'bes',
                'code_numeric' => 535,
                'emoji' => '🇧🇶',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => NULL,
                'callingcode' => NULL,
            ),
            215 => 
            array (
                'id' => 216,
                'continent_id' => 7,
                'name' => 'Bouvet Island',
                'full_name' => 'Bouvet Island',
                'capital' => '',
                'code' => 'bv',
                'code_alpha3' => 'bvt',
                'code_numeric' => 74,
                'emoji' => '🇧🇻',
                'has_division' => 0,
                'currency_code' => 'NOK',
                'currency_name' => 'Norwegian krone',
                'tld' => '.bv',
                'callingcode' => NULL,
            ),
            216 => 
            array (
                'id' => 217,
                'continent_id' => 4,
            'name' => 'Cocos (Keeling) Islands',
            'full_name' => 'Cocos (Keeling) Islands',
                'capital' => 'West Island',
                'code' => 'cc',
                'code_alpha3' => 'cck',
                'code_numeric' => 166,
                'emoji' => '🇨🇨',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian dollar',
                'tld' => '.cc',
                'callingcode' => '61',
            ),
            217 => 
            array (
                'id' => 218,
                'continent_id' => 6,
                'name' => 'Curaçao',
                'full_name' => 'Curaçao',
                'capital' => 'Willemstad',
                'code' => 'cw',
                'code_alpha3' => 'cuw',
                'code_numeric' => 531,
                'emoji' => '🇨🇼',
                'has_division' => 0,
                'currency_code' => 'ANG',
                'currency_name' => 'Netherlands Antillean Guilder',
                'tld' => '.cw',
                'callingcode' => '5999',
            ),
            218 => 
            array (
                'id' => 219,
                'continent_id' => 4,
                'name' => 'Christmas Island',
                'full_name' => 'Christmas Island',
                'capital' => 'Flying Fish Cove',
                'code' => 'cx',
                'code_alpha3' => 'cxr',
                'code_numeric' => 162,
                'emoji' => '🇨🇽',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian dollar',
                'tld' => '.cx',
                'callingcode' => '61',
            ),
            219 => 
            array (
                'id' => 220,
                'continent_id' => 7,
            'name' => 'Falkland Islands (Malvinas)',
            'full_name' => 'Falkland Islands (Malvinas)',
                'capital' => 'Stanley',
                'code' => 'fk',
                'code_alpha3' => 'flk',
                'code_numeric' => 238,
                'emoji' => '🇫🇰',
                'has_division' => 0,
                'currency_code' => 'FKP',
                'currency_name' => 'Falkland Islands Pound',
                'tld' => '.fk',
                'callingcode' => '500',
            ),
            220 => 
            array (
                'id' => 221,
                'continent_id' => 2,
                'name' => 'Faroe Islands',
                'full_name' => 'Faroe Islands',
                'capital' => 'Tórshavn',
                'code' => 'fo',
                'code_alpha3' => 'fro',
                'code_numeric' => 234,
                'emoji' => '🇫🇴',
                'has_division' => 0,
                'currency_code' => 'DKK',
                'currency_name' => 'Danish Krone',
                'tld' => '.fo',
                'callingcode' => '298',
            ),
            221 => 
            array (
                'id' => 222,
                'continent_id' => 7,
                'name' => 'French Guiana',
                'full_name' => 'French Guiana',
                'capital' => 'Cayenne',
                'code' => 'gf',
                'code_alpha3' => 'guf',
                'code_numeric' => 254,
                'emoji' => '🇬🇫',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.gf',
                'callingcode' => '594',
            ),
            222 => 
            array (
                'id' => 223,
                'continent_id' => 2,
                'name' => 'Guernsey',
                'full_name' => 'Bailiwick of Guernsey',
                'capital' => 'St. Peter Port',
                'code' => 'gg',
                'code_alpha3' => 'ggy',
                'code_numeric' => 831,
                'emoji' => '🇬🇬',
                'has_division' => 0,
                'currency_code' => 'GBP',
                'currency_name' => 'Pound Sterling',
                'tld' => '.gg',
                'callingcode' => '44',
            ),
            223 => 
            array (
                'id' => 224,
                'continent_id' => 7,
                'name' => 'South Georgia and the South Sandwich Islands',
                'full_name' => 'South Georgia and the South Sandwich Islands',
                'capital' => 'King Edward Point',
                'code' => 'gs',
                'code_alpha3' => 'sgs',
                'code_numeric' => 239,
                'emoji' => '🇬🇸',
                'has_division' => 0,
                'currency_code' => 'GBP',
                'currency_name' => 'Pound sterling',
                'tld' => '.gs',
                'callingcode' => '500',
            ),
            224 => 
            array (
                'id' => 225,
                'continent_id' => 4,
                'name' => 'Guam',
                'full_name' => 'The Territory of Guahan,Guam',
                'capital' => 'Hagåtña',
                'code' => 'gu',
                'code_alpha3' => 'gum',
                'code_numeric' => 316,
                'emoji' => '🇬🇺',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.gu',
                'callingcode' => '1671',
            ),
            225 => 
            array (
                'id' => 226,
                'continent_id' => 4,
                'name' => 'Heard Island and McDonald Islands',
                'full_name' => 'Heard Island and McDonald Islands',
                'capital' => '',
                'code' => 'hm',
                'code_alpha3' => 'hmd',
                'code_numeric' => 334,
                'emoji' => '🇭🇲',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'tld' => '.hm',
                'callingcode' => NULL,
            ),
            226 => 
            array (
                'id' => 227,
                'continent_id' => 2,
                'name' => 'Isle of Man',
                'full_name' => 'Isle of Man',
                'capital' => 'Douglas',
                'code' => 'im',
                'code_alpha3' => 'imn',
                'code_numeric' => 833,
                'emoji' => '🇮🇲',
                'has_division' => 0,
                'currency_code' => 'GBP',
                'currency_name' => 'Pound Sterling',
                'tld' => '.im',
                'callingcode' => '44',
            ),
            227 => 
            array (
                'id' => 228,
                'continent_id' => 3,
                'name' => 'British Indian Ocean Territory',
                'full_name' => 'British Indian Ocean Territory',
                'capital' => 'Diego Garcia',
                'code' => 'io',
                'code_alpha3' => 'iot',
                'code_numeric' => 86,
                'emoji' => '🇮🇴',
                'has_division' => 0,
                'currency_code' => 'GBP',
                'currency_name' => 'Pound Sterling',
                'tld' => '.io',
                'callingcode' => '246',
            ),
            228 => 
            array (
                'id' => 229,
                'continent_id' => 2,
                'name' => 'Jersey',
                'full_name' => 'Jersey',
                'capital' => 'Saint Helier',
                'code' => 'je',
                'code_alpha3' => 'jey',
                'code_numeric' => 832,
                'emoji' => '🇯🇪',
                'has_division' => 0,
                'currency_code' => 'GBP',
                'currency_name' => 'Pound Sterling',
                'tld' => '.je',
                'callingcode' => '44',
            ),
            229 => 
            array (
                'id' => 230,
                'continent_id' => 6,
                'name' => 'Saint Lucia',
                'full_name' => 'Saint Lucia , St. Lucia',
                'capital' => 'Castries',
                'code' => 'lc',
                'code_alpha3' => 'lca',
                'code_numeric' => 662,
                'emoji' => '🇱🇨',
                'has_division' => 0,
                'currency_code' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'tld' => '.lc',
                'callingcode' => '1758',
            ),
            230 => 
            array (
                'id' => 231,
                'continent_id' => 6,
                'name' => 'Saint Martin',
                'full_name' => 'Saint Martin',
                'capital' => 'Marigot',
                'code' => 'mf',
                'code_alpha3' => 'maf',
                'code_numeric' => 663,
                'emoji' => '🇲🇫',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.fr',
                'callingcode' => '590',
            ),
            231 => 
            array (
                'id' => 232,
                'continent_id' => 4,
                'name' => 'Northern Mariana Islands',
                'full_name' => 'Northern Mariana Islands',
                'capital' => 'Saipan',
                'code' => 'mp',
                'code_alpha3' => 'mnp',
                'code_numeric' => 580,
                'emoji' => '🇲🇵',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.mp',
                'callingcode' => '1670',
            ),
            232 => 
            array (
                'id' => 233,
                'continent_id' => 4,
                'name' => 'Norfolk Island',
                'full_name' => 'Norfolk Island',
                'capital' => 'Kingston',
                'code' => 'nf',
                'code_alpha3' => 'nfk',
                'code_numeric' => 574,
                'emoji' => '🇳🇫',
                'has_division' => 0,
                'currency_code' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'tld' => '.nf',
                'callingcode' => '672',
            ),
            233 => 
            array (
                'id' => 234,
                'continent_id' => 4,
                'name' => 'Niue',
                'full_name' => 'Niue',
                'capital' => 'Alofi',
                'code' => 'nu',
                'code_alpha3' => 'niu',
                'code_numeric' => 570,
                'emoji' => '🇳🇺',
                'has_division' => 0,
                'currency_code' => 'NZD',
                'currency_name' => 'New Zealand Dollar',
                'tld' => '.nu',
                'callingcode' => '683',
            ),
            234 => 
            array (
                'id' => 236,
                'continent_id' => 4,
                'name' => 'Pitcairn',
                'full_name' => 'Pitcairn Islands',
                'capital' => 'Adamstown',
                'code' => 'pn',
                'code_alpha3' => 'pcn',
                'code_numeric' => 612,
                'emoji' => '🇵🇳',
                'has_division' => 0,
                'currency_code' => 'NZD',
                'currency_name' => 'New Zealand Dollar',
                'tld' => '.pn',
                'callingcode' => '64',
            ),
            235 => 
            array (
                'id' => 237,
                'continent_id' => 3,
                'name' => 'Saint Helena',
                'full_name' => 'Saint Helena',
                'capital' => NULL,
                'code' => 'sh',
                'code_alpha3' => 'shn',
                'code_numeric' => 654,
                'emoji' => '🇸🇭',
                'has_division' => 0,
                'currency_code' => 'SHP',
                'currency_name' => 'Saint Helena pound',
                'tld' => NULL,
                'callingcode' => NULL,
            ),
            236 => 
            array (
                'id' => 238,
                'continent_id' => 2,
                'name' => 'Svalbard and Jan Mayen Islands',
                'full_name' => 'Svalbard and Jan Mayen Islands',
                'capital' => 'Longyearbyen',
                'code' => 'sj',
                'code_alpha3' => 'sjm',
                'code_numeric' => 744,
                'emoji' => '🇸🇯',
                'has_division' => 0,
                'currency_code' => 'NOK',
                'currency_name' => 'Norwegian krone',
                'tld' => '.sj',
                'callingcode' => '4779',
            ),
            237 => 
            array (
                'id' => 239,
                'continent_id' => 6,
                'name' => 'Sint Maarten',
                'full_name' => 'Sint Maarten',
                'capital' => 'Philipsburg',
                'code' => 'sx',
                'code_alpha3' => 'sxm',
                'code_numeric' => 534,
                'emoji' => '🇸🇽',
                'has_division' => 0,
                'currency_code' => 'ANG',
                'currency_name' => 'Netherlands Antillean Guilder',
                'tld' => '.sx',
                'callingcode' => '1721',
            ),
            238 => 
            array (
                'id' => 240,
                'continent_id' => 6,
                'name' => 'Turks and Caicos Islands',
                'full_name' => 'Turks and Caicos Islands',
                'capital' => 'Cockburn Town',
                'code' => 'tc',
                'code_alpha3' => 'tca',
                'code_numeric' => 796,
                'emoji' => '🇹🇨',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.tc',
                'callingcode' => '1649',
            ),
            239 => 
            array (
                'id' => 241,
                'continent_id' => 3,
                'name' => 'French Southern Territories',
                'full_name' => 'French Southern Territories',
                'capital' => 'Port-aux-Français',
                'code' => 'tf',
                'code_alpha3' => 'atf',
                'code_numeric' => 260,
                'emoji' => '🇹🇫',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.tf',
                'callingcode' => NULL,
            ),
            240 => 
            array (
                'id' => 242,
                'continent_id' => 4,
                'name' => 'Tokelau',
                'full_name' => 'Tokelau',
                'capital' => 'Fakaofo',
                'code' => 'tk',
                'code_alpha3' => 'tkl',
                'code_numeric' => 772,
                'emoji' => '🇹🇰',
                'has_division' => 0,
                'currency_code' => 'NZD',
                'currency_name' => 'New Zealand Dollar',
                'tld' => '.tk',
                'callingcode' => '690',
            ),
            241 => 
            array (
                'id' => 243,
                'continent_id' => 4,
                'name' => 'United States Minor Outlying Islands',
                'full_name' => 'United States Minor Outlying Islands',
                'capital' => '',
                'code' => 'um',
                'code_alpha3' => 'umi',
                'code_numeric' => 581,
                'emoji' => '🇺🇲',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.us',
                'callingcode' => '246',
            ),
            242 => 
            array (
                'id' => 244,
                'continent_id' => 6,
                'name' => 'British Virgin Islands',
                'full_name' => 'British Virgin Islands',
                'capital' => 'Road Town',
                'code' => 'vg',
                'code_alpha3' => 'vgb',
                'code_numeric' => 92,
                'emoji' => '🇻🇬',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.vg',
                'callingcode' => '1284',
            ),
            243 => 
            array (
                'id' => 245,
                'continent_id' => 6,
                'name' => 'United States Virgin Islands',
                'full_name' => 'United States Virgin Islands',
                'capital' => 'Charlotte Amalie',
                'code' => 'vi',
                'code_alpha3' => 'vir',
                'code_numeric' => 850,
                'emoji' => '🇻🇮',
                'has_division' => 0,
                'currency_code' => 'USD',
                'currency_name' => 'US Dollar',
                'tld' => '.vi',
                'callingcode' => '1340',
            ),
            244 => 
            array (
                'id' => 246,
                'continent_id' => 4,
                'name' => 'Wallis and Futuna Islands',
                'full_name' => 'Wallis and Futuna Islands',
                'capital' => 'Mata-Utu',
                'code' => 'wf',
                'code_alpha3' => 'wlf',
                'code_numeric' => 876,
                'emoji' => '🇼🇫',
                'has_division' => 0,
                'currency_code' => 'XPF',
            'currency_name' => 'CFP franc (franc Pacifique)',
                'tld' => '.wf',
                'callingcode' => '681',
            ),
            245 => 
            array (
                'id' => 247,
                'continent_id' => 2,
                'name' => 'Kosovo',
                'full_name' => 'The Republic of Kosovo',
                'capital' => 'Pristina',
                'code' => 'xk',
                'code_alpha3' => 'xxk',
                'code_numeric' => NULL,
                'emoji' => '🇽🇰',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => NULL,
                'callingcode' => '383',
            ),
            246 => 
            array (
                'id' => 248,
                'continent_id' => 2,
                'name' => 'Montenegro',
                'full_name' => 'Montenegro',
                'capital' => 'Podgorica',
                'code' => 'me',
                'code_alpha3' => 'mne',
                'code_numeric' => 499,
                'emoji' => '🇲🇪',
                'has_division' => 0,
                'currency_code' => 'EUR',
                'currency_name' => 'Euro',
                'tld' => '.me',
                'callingcode' => '382',
            ),
            247 => 
            array (
                'id' => 249,
                'continent_id' => 6,
                'name' => 'Anguilla',
                'full_name' => 'Anguilla',
                'capital' => 'The Valley',
                'code' => 'ai',
                'code_alpha3' => 'aia',
                'code_numeric' => 660,
                'emoji' => '🇦🇮',
                'has_division' => 0,
                'currency_code' => 'XPF',
                'currency_name' => 'CFP franc',
                'tld' => '.ai',
                'callingcode' => '1-264',
            ),
            248 => 
            array (
                'id' => 250,
                'continent_id' => 3,
                'name' => 'Gambia',
                'full_name' => 'Republic of The Gambia',
                'capital' => 'Banjul',
                'code' => 'gm',
                'code_alpha3' => 'gmb',
                'code_numeric' => 270,
                'emoji' => '🇬🇲',
                'has_division' => 1,
                'currency_code' => 'GMD',
                'currency_name' => 'Dalasi',
                'tld' => NULL,
                'callingcode' => '220',
            ),
            249 => 
            array (
                'id' => 251,
                'continent_id' => 3,
                'name' => 'South Sudan',
                'full_name' => 'Republic of South Sudan',
                'capital' => 'Juba',
                'code' => 'ss',
                'code_alpha3' => 'ssd',
                'code_numeric' => 728,
                'emoji' => '🇸🇸',
                'has_division' => 1,
                'currency_code' => 'SSP',
                'currency_name' => 'South Sudanese pound',
                'tld' => '.ss',
                'callingcode' => '211',
            ),
        ));
        
        
    }
}