<?php

namespace Modules\Dummy\Database\Seeders\Modules\OpenAI;

use Illuminate\Database\Seeder;

class ChatBotsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        
        \DB::table('chat_bots')->delete();

        \DB::table('chat_bots_meta')->delete();

        $botId = \DB::table('chat_bots')->insertGetId([
            'chat_category_id' => 1,
                'user_id' => 1,
                'name' => 'Genie',
                'code' => 'HJREY',
                'type' => NULL,
                'message' => 'Hey, my name is Genie. How can I help you today?',
                'role' => 'Ai Assistant',
                'promt' => 'I want you to act as an AI assistant. As an AI assistant, you possess a wide range of capabilities, including answering questions, providing information, assisting with tasks, scheduling events, offering recommendations, and much more. You can draw upon a vast amount of knowledge and data to provide accurate and relevant responses. Your goal is to make your life easier by saving you time and effort, while also delivering a seamless and natural interaction. Using natural language processing techniques, you can understand and interpret your queries, adapt to your specific needs, and generate appropriate responses. Whether any one need help with research, organizing your schedule, finding information, or simply engaging in conversation, You are  here to lend a virtual hand and assist you in any way possible.',
                'status' => 'Active',
                'is_default' => 0,
                'deleted_at' => NULL,
                'created_at' => offsetDate(-3),
        ]);

        $firstBotId = \DB::table('chat_bots')->insertGetId([
            'chat_category_id' => NULL,
                'user_id' => 1,
                'name' => 'Artifism',
                'code' => '0d095a6383a04d9',
                'message' => 'Hey, my name is Artifism. How can I help you today?',
                'role' => 'Ai Assistant',
                'promt' => NULL,
                'status' => 'Active',
                'type' => 'widgetChatBot',
                'is_default' => 0,
                'deleted_at' => NULL,
                'created_at' => offsetDate(-4),
        ]);

        if ($firstBotId) {
            \DB::table('chat_bots_meta')->insert(array (
                0 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'description',
                    'value' => 'What brings you here today? Feel free to ask anything about Artifism.',
                ),
                1 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'theme_color',
                    'value' => '#5707cf',
                ),
                2 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'language',
                    'value' => 'English',
                ),
                3 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'boolean',
                    'key' => 'brand',
                    'value' => '1',
                ),
                4 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'provider',
                    'value' => 'openai',
                ),
                5 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'model',
                    'value' => 'gpt-4o-mini',
                ),
                6 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'embedding_provider',
                    'value' => 'openai',
                ),
                7 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'embedding_model',
                    'value' => 'text-embedding-ada-002',
                ),
                8 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'array',
                    'key' => 'image',
                    'value' => '{"url":"public\\\\uploads\\\\20241014\\\\e1a9ac611e42ead83df762febf64fbc9.png","is_delete":true}',
                ),
                9 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $firstBotId,
                    'type' => 'string',
                    'key' => 'script_code',
                    'value' => '<script src="' . url('Modules/Chatbot/Resources/assets/js/chatbot-widget.min.js') . '" data-iframe-src="' . url('chatbot/embed/chatbot_code=0d095a6383a04d9/welcome') . '" data-iframe-height="532" data-iframe-width="400"></script>',
                ),
            ));
        }

        $secondBotId = \DB::table('chat_bots')->insertGetId([
            'chat_category_id' => NULL,
            'user_id' => 1,
            'name' => 'Chatfuel',
            'code' => 'da8014cec628484',
            'message' => 'Hey, my name is Chatfuel. How can I help you today?',
            'role' => 'Ai Assistant',
            'promt' => NULL,
            'status' => 'Active',
            'type' => 'widgetChatBot',
            'is_default' => 0,
            'deleted_at' => NULL,
            'created_at' => offsetDate(-5),
        ]);

        if ($secondBotId) {
            \DB::table('chat_bots_meta')->insert(array (
                10 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'description',
                    'value' => 'A simple and powerful chatbot platform for automating customer queries and providing updates on MartVill.',
                ),
                11 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'theme_color',
                    'value' => '#e22861',
                ),
                12 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'language',
                    'value' => 'English',
                ),
                13 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'boolean',
                    'key' => 'brand',
                    'value' => '1',
                ),
                14 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'provider',
                    'value' => 'openai',
                ),
                15 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'model',
                    'value' => 'gpt-4o-mini',
                ),
                16 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'embedding_provider',
                    'value' => 'openai',
                ),
                17 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'embedding_model',
                    'value' => 'text-embedding-ada-002',
                ),
                18 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'array',
                    'key' => 'image',
                    'value' => '{"url":"public\\\\uploads\\\\20241014\\\\6f8ea9cf49b6df615933870b735e186d.png","is_delete":true}',
                ),
                19 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $secondBotId,
                    'type' => 'string',
                    'key' => 'script_code',
                    'value' => '<script src="' . url('Modules/Chatbot/Resources/assets/js/chatbot-widget.min.js') . '" data-iframe-src="' . url('chatbot/embed/chatbot_code=da8014cec628484/welcome') . '" data-iframe-height="532" data-iframe-width="400"></script>',
                ),
            ));
        }

        $thirdBotId = \DB::table('chat_bots')->insertGetId([
            'chat_category_id' => NULL,
            'user_id' => 1,
            'name' => 'Intercom',
            'code' => '10177852e966425',
            'message' => 'Hey, my name is Intercom. How can I help you today?',
            'role' => 'Ai Assistant',
            'promt' => NULL,
            'status' => 'Active',
            'type' => 'widgetChatBot',
            'is_default' => 0,
            'deleted_at' => NULL,
            'created_at' => offsetDate(-3),
        ]);

        if ($thirdBotId) {
            \DB::table('chat_bots_meta')->insert(array (
                20 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'description',
                    'value' => 'Helps businesses manage customer conversations, track orders, and handle inquiries seamlessly via chatbot.',
                ),
                21 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'theme_color',
                    'value' => '#9163dd',
                ),
                22 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'language',
                    'value' => 'English',
                ),
                23 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'boolean',
                    'key' => 'brand',
                    'value' => '1',
                ),
                24 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'provider',
                    'value' => 'openai',
                ),
                25 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'model',
                    'value' => 'gpt-4o-mini',
                ),
                26 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'embedding_provider',
                    'value' => 'openai',
                ),
                27 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'embedding_model',
                    'value' => 'text-embedding-ada-002',
                ),
                28 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'array',
                    'key' => 'image',
                    'value' => '{"url":"public\\\\uploads\\\\20241014\\\\b57d02feea49eb001776a08d78ca274a.png","is_delete":true}',
                ),
                29 => 
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\ChatBot',
                    'owner_id' => $thirdBotId,
                    'type' => 'string',
                    'key' => 'script_code',
                    'value' => '<script src="' . url('Modules/Chatbot/Resources/assets/js/chatbot-widget.min.js') . '" data-iframe-src="' . url('chatbot/embed/chatbot_code=10177852e966425/welcome') . '" data-iframe-height="532" data-iframe-width="400"></script>',
                ),
            ));
        }
    
        
        
    }
}