<?php

namespace Modules\Dummy\Database\Seeders\Modules\OpenAI\versions\v4_0_0;

use App\Models\Permission;
use Illuminate\Database\Seeder;
use DB;

class TextToVideoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        \DB::beginTransaction();

        try {
            // First Insert
            $firstInsertGetId = \DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'A group of adorable cartoon animals marching in a festival with balloons confetti and joyful music',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => '{"response":{"code":200,"body":{"video":{"url":"https:\\/\\/v3.fal.media\\/files\\/koala\\/V0eGTP_bjIQgDza7ieJYG_output.mp4","content_type":"video\\/mp4","file_name":"output.mp4","file_size":10228789}}},"url":"https:\\/\\/v3.fal.media\\/files\\/koala\\/V0eGTP_bjIQgDza7ieJYG_output.mp4"}',
                'unique_identifier' => 'b9319bab-f918-4b15-b685-b00d497a07ee',
                'provider' => 'falai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'text_to_video_chat',
                'status' => 'Completed',
                'created_at' => offsetDate(-3),
            ]);

            if ($firstInsertGetId) {
                // Second Insert with Parent ID
                $secondInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $firstInsertGetId,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                    'created_at' => offsetDate(-3),
                ]);

                if ($secondInsertGetId) {
                    // Bulk Insert Meta Data for the second insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => 'A group of adorable cartoon animals marching in a festival with balloons confetti and joyful music',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'original_name',
                            'value' => 'A group of adorable cartoon animals marching in a festival with balloons confetti and joyful music',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_id',
                            'value' => '59a01557-aa1b-49f7-8ef0-19470e0500bb',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'videos_url',
                            'value' => '["20250325\\1603cec10ebab10d644557138a8368f3.mp4"]',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"kling-video-v1-pro","aspect_ratio":"16:9","duration":"5","camera_control":"down_back","resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                    ]);
                }

                // Third Insert
                $thirdInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $secondInsertGetId,
                    'user_id' => 1,
                    'title' => 'A group of adorable cartoon animals marching in a festival with balloons confetti and joyful music',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => 'f30cedc5-568c-4fdf-beb3-5f8edf384ab5',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                    'created_at' => offsetDate(-3)
                ]);

                if ($thirdInsertGetId) {
                    // Bulk Insert Meta Data for the third insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"kling-video-v1-pro","aspect_ratio":"16:9","duration":"5","camera_control":"down_back","resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => '20250325\\1603cec10ebab10d644557138a8368f3.mp4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'integer',
                            'key' => 'video_creator_id',
                            'value' => '1',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'slug',
                            'value' => 'a-group-of-adorable-cartoon-animals-marching-in-a-festival-with-balloons-confetti-and-joyful-music',
                        ],
                    ]);
                }
            }

            $firstInsertGetId = \DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => '{"response":{"code":200,"body":{"video":{"url":"https:\\/\\/v3.fal.media\\/files\\/monkey\\/fJZRFeQBDHQ0kf_E7PBbn_video-1742884589.mp4","content_type":"application\\/octet-stream","file_name":"video-1742884589.mp4","file_size":899004},"seed":112}},"url":"https:\\/\\/v3.fal.media\\/files\\/monkey\\/fJZRFeQBDHQ0kf_E7PBbn_video-1742884589.mp4"}',
                'unique_identifier' => 'd75b50d0-5498-4c1c-82ad-ece7bfb9dcd5',
                'provider' => 'falai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'text_to_video_chat',
                'status' => 'Completed',
                'created_at' => offsetDate(-3)
            ]);

            if ($firstInsertGetId) {
                // Second Insert with Parent ID
                $secondInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $firstInsertGetId,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                    'created_at' => offsetDate(-3),
                ]);

                if ($secondInsertGetId) {
                    // Bulk Insert Meta Data for the second insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'original_name',
                            'value' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_id',
                            'value' => 'd83fe9e5-e8ce-4695-8e3c-f36235315fb8',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'videos_url',
                            'value' => '["20250325\\c95a816d746aa21a367a4a39568cde02.mp4"]',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"hunyuan-video","aspect_ratio":"16:9","duration":null,"camera_control":null,"resolution":"480p","num_frames":"129","pro_mode":"On","enable_safety_checker":"On","negative_prompt":null}',
                        ],
                    ]);
                }

                // Third Insert
                $thirdInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $secondInsertGetId,
                    'user_id' => 1,
                    'title' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => 'cf8f0f47-4754-4680-a6e4-d8ae94345829',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                    'created_at' => '2025-03-25 06:36:39',
                    'updated_at' => '2025-03-25 06:36:39',
                    'created_at' => offsetDate(-3)
                ]);

                if ($thirdInsertGetId) {
                    // Bulk Insert Meta Data for the third insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"hunyuan-video","aspect_ratio":"16:9","duration":null,"camera_control":null,"resolution":"480p","num_frames":"129","pro_mode":"On","enable_safety_checker":"On","negative_prompt":null}',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => '20250325\\c95a816d746aa21a367a4a39568cde02.mp4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'integer',
                            'key' => 'video_creator_id',
                            'value' => '1',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'slug',
                            'value' => 'a-city-where-humanoid-robots-start-gaining-consciousness-and-question-their-purpose',
                        ],
                    ]);
                }
            }

            $firstInsertGetId = \DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'A grand castle overlooking a village with knights training dragons flying in the sky and magic spells being cast',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => '{"response":{"code":200,"body":{"video":{"url":"https:\\/\\/fal.media\\/files\\/panda\\/wGmTvIW-PIWS1czNRvsr-_output.mp4","content_type":"video\\/mp4","file_name":"output.mp4","file_size":2625820}}},"url":"https:\\/\\/fal.media\\/files\\/panda\\/wGmTvIW-PIWS1czNRvsr-_output.mp4"}',
                'unique_identifier' => '44faa399-6476-4cd3-9c57-ec7a66aaf9b2',
                'provider' => 'falai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'text_to_video_chat',
                'status' => 'Completed',
                'created_at' => offsetDate(-3)
            ]);

            if ($firstInsertGetId) {
                // Second Insert with Parent ID
                $secondInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $firstInsertGetId,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                    'created_at' => offsetDate(-3),
                ]);

                if ($secondInsertGetId) {
                    // Bulk Insert Meta Data for the second insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => 'A grand castle overlooking a village with knights training dragons flying in the sky and magic spells being cast',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'original_name',
                            'value' => 'A grand castle overlooking a village with knights training dragons flying in the sky and magic spells being cast',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_id',
                            'value' => '71634376-14a4-4360-8a15-0c9291f271c2',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'videos_url',
                            'value' => '["20250325\\23ba5a6508178654cc699aa5524014ff.mp4"]',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"minimax-video-01","aspect_ratio":null,"duration":null,"camera_control":null,"resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                    ]);
                }

                // Third Insert
                $thirdInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $secondInsertGetId,
                    'user_id' => 1,
                    'title' => 'A grand castle overlooking a village with knights training dragons flying in the sky and magic spells being cast',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '883c5bc5-7867-4d8d-9562-f4804d507388',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                    'created_at' => offsetDate(-3)
                ]);

                if ($thirdInsertGetId) {
                    // Bulk Insert Meta Data for the third insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"minimax-video-01","aspect_ratio":null,"duration":null,"camera_control":null,"resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => '20250325\\23ba5a6508178654cc699aa5524014ff.mp4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'integer',
                            'key' => 'video_creator_id',
                            'value' => '1',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'slug',
                            'value' => 'a-grand-castle-overlooking-a-village-with-knights-training-dragons-flying-in-the-sky-and-magic-spells-being-cast',
                        ],
                    ]);
                }
            }

            $firstInsertGetId = \DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => '{"response":{"code":200,"body":{"video":{"url":"https:\\/\\/fal.media\\/files\\/panda\\/L5T0AHcllVMdPkwRlL6YS_output_1742887115.mp4","content_type":"application\\/octet-stream","file_name":"output_1742887115.mp4","file_size":2255448}}},"url":"https:\\/\\/fal.media\\/files\\/panda\\/L5T0AHcllVMdPkwRlL6YS_output_1742887115.mp4"}',
                'unique_identifier' => 'cc0307e7-442b-4069-92cb-31281f17a4b5',
                'provider' => 'falai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'text_to_video_chat',
                'status' => 'Completed',
                'created_at' => offsetDate(-3)
            ]);

            if ($firstInsertGetId) {
                // Second Insert with Parent ID
                $secondInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $firstInsertGetId,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                    'created_at' => offsetDate(-3),
                ]);

                if ($secondInsertGetId) {
                    // Bulk Insert Meta Data for the second insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'original_name',
                            'value' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_id',
                            'value' => '8bfb7328-f015-4f94-941d-1362806325f4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'videos_url',
                            'value' => '["20250325\\51c706a1084ded8e33926dfdce4f3346.mp4"]',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"mochi-v1","aspect_ratio":null,"duration":null,"camera_control":null,"resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                    ]);
                }

                // Third Insert
                $thirdInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $secondInsertGetId,
                    'user_id' => 1,
                    'title' => 'A city where humanoid robots start gaining consciousness and question their purpose',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '3e7f3933-c27c-4da2-9035-4058e5fb16cd',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                    'created_at' => offsetDate(-3)
                ]);

                if ($thirdInsertGetId) {
                    // Bulk Insert Meta Data for the third insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"mochi-v1","aspect_ratio":null,"duration":null,"camera_control":null,"resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => '20250325\\51c706a1084ded8e33926dfdce4f3346.mp4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'integer',
                            'key' => 'video_creator_id',
                            'value' => '1',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'slug',
                            'value' => 'a-city-where-humanoid-robots-start-gaining-consciousness-and-question-their-purpose1742887146',
                        ],
                    ]);
                }
            }

            $firstInsertGetId = \DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'Two massive spaceships engage in combat near a distant planet with laser beams and explosions lighting up the dark void',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => '{"response":{"code":200,"body":{"video":{"url":"https:\\/\\/v3.fal.media\\/files\\/panda\\/NKOuiFYvpaMFYC9osJrzI_output.mp4","content_type":"video\\/mp4","file_name":"output.mp4","file_size":3125195}}},"url":"https:\\/\\/v3.fal.media\\/files\\/panda\\/NKOuiFYvpaMFYC9osJrzI_output.mp4"}',
                'unique_identifier' => '503b6663-5b81-4776-8c5f-f0fbffa42307',
                'provider' => 'falai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'text_to_video_chat',
                'status' => 'Completed',
                'created_at' => offsetDate(-3)
            ]);

            if ($firstInsertGetId) {
                // Second Insert with Parent ID
                $secondInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $firstInsertGetId,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                    'created_at' => offsetDate(-3),
                ]);

                if ($secondInsertGetId) {
                    // Bulk Insert Meta Data for the second insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => 'Two massive spaceships engage in combat near a distant planet with laser beams and explosions lighting up the dark void',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'original_name',
                            'value' => 'Two massive spaceships engage in combat near a distant planet with laser beams and explosions lighting up the dark void',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_id',
                            'value' => '1afa433e-b94b-40f3-9950-149594aadc59',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'videos_url',
                            'value' => '["20250325\\8f6b135f240840b45214d062f2ccfd5d.mp4"]',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"luma-dream-machine","aspect_ratio":"4:3","duration":"5","camera_control":null,"resolution":"540p","num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                    ]);
                }

                // Third Insert
                $thirdInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $secondInsertGetId,
                    'user_id' => 1,
                    'title' => 'Two massive spaceships engage in combat near a distant planet with laser beams and explosions lighting up the dark void',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '7cac4348-28c0-446c-b8ba-6516b53dbb50',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                    'created_at' => offsetDate(-3)
                ]);

                if ($thirdInsertGetId) {
                    // Bulk Insert Meta Data for the third insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"luma-dream-machine","aspect_ratio":"4:3","duration":"5","camera_control":null,"resolution":"540p","num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => '20250325\\8f6b135f240840b45214d062f2ccfd5d.mp4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'integer',
                            'key' => 'video_creator_id',
                            'value' => '1',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'slug',
                            'value' => 'two-massive-spaceships-engage-in-combat-near-a-distant-planet-with-laser-beams-and-explosions-lighting-up-the-dark-void',
                        ],
                    ]);
                }
            }

            $firstInsertGetId = \DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'A friendly alien visiting Earth and exploring a human city with childlike curiosity',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => '{"response":{"code":200,"body":{"video":{"url":"https:\\/\\/v3.fal.media\\/files\\/zebra\\/3moHcWtzafbm8EJpZJVxj_output.mp4","content_type":"video\\/mp4","file_name":"output.mp4","file_size":3316102}}},"url":"https:\\/\\/v3.fal.media\\/files\\/zebra\\/3moHcWtzafbm8EJpZJVxj_output.mp4"}',
                'unique_identifier' => '7b22843c-c60b-40ba-9a3b-2ecb97b3e95b',
                'provider' => 'falai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'text_to_video_chat',
                'status' => 'Completed',
                'created_at' => offsetDate(-3)
            ]);

            if ($firstInsertGetId) {
                // Second Insert with Parent ID
                $secondInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $firstInsertGetId,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                    'created_at' => offsetDate(-3),
                ]);

                if ($secondInsertGetId) {
                    // Bulk Insert Meta Data for the second insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => 'A friendly alien visiting Earth and exploring a human city with childlike curiosity',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'original_name',
                            'value' => 'A friendly alien visiting Earth and exploring a human city with childlike curiosity',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'string',
                            'key' => 'file_id',
                            'value' => '322f766d-cfb0-40b8-a996-10b405d36f92',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'videos_url',
                            'value' => '["20250325\\ee7d3dd84b8d4a1158951ec6b6fc2ef6.mp4"]',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $secondInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"kling-video-v1.6-standard","aspect_ratio":"16:9","duration":"5","camera_control":"down_back","resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                    ]);
                }

                // Third Insert
                $thirdInsertGetId = \DB::table('archives')->insertGetId([
                    'parent_id' => $secondInsertGetId,
                    'user_id' => 1,
                    'title' => 'A friendly alien visiting Earth and exploring a human city with childlike curiosity',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => 'cd9c9074-be16-4b65-97d7-8856b666410c',
                    'provider' => 'falai',
                    'expense' =>  NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                    'created_at' => offsetDate(-3)
                ]);

                if ($thirdInsertGetId) {
                    // Bulk Insert Meta Data for the third insert
                    \DB::table('archives_meta')->insert([
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'array',
                            'key' => 'generation_options',
                            'value' => '{"service":"text-to-video","model":"kling-video-v1.6-standard","aspect_ratio":"16:9","duration":"5","camera_control":"down_back","resolution":null,"num_frames":null,"pro_mode":null,"enable_safety_checker":null,"negative_prompt":null}',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'file_name',
                            'value' => '20250325\\ee7d3dd84b8d4a1158951ec6b6fc2ef6.mp4',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'integer',
                            'key' => 'video_creator_id',
                            'value' => '1',
                        ],
                        [
                            'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                            'owner_id' => $thirdInsertGetId,
                            'type' => 'string',
                            'key' => 'slug',
                            'value' => 'a-friendly-alien-visiting-earth-and-exploring-a-human-city-with-childlike-curiosity',
                        ],
                    ]);
                }
            }

            \DB::commit();
        } catch (\Exception $e) {
            \DB::rollBack();
            throw $e;
        }
    }
}