<?php

namespace Modules\Dummy\Database\Seeders\Modules\OpenAI\versions\v5_2_0;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\OpenAI\Entities\Avatar;

class AvatarTableWithMetaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $avatarsWithImage = [
            0 => [
                'user_id' => 1,
                'name' => 'Ada',
                'avatar_id' => '03cee7ec-ac90-45ec-8c20-74a399cf3dc4',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/ada.png',
            ],
            1 => [
                'user_id' => 1,
                'name' => 'Aaron',
                'avatar_id' => '99b841f2-8acf-4c7f-8add-9ea7ac98689d',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/aaron.png',
            ],
            2 => [
                'user_id' => 1,
                'name' => 'Alex',
                'avatar_id' => 'anna_costume1_cameraA',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/alex.png',
            ],
            3 => [
                'user_id' => 1,
                'name' => 'Arielle',
                'avatar_id' => '1087cd3e-2095-4aaa-bded-da92a5f173ef',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/arielle.png',
            ],
            4 => [
                'user_id' => 1,
                'name' => 'Ace',
                'avatar_id' => 'f41b7f1f-ff0d-4c8e-9d1f-f87dbb862750',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/ace.png',
            ],
            5 => [
                'user_id' => 1,
                'name' => 'Callum',
                'avatar_id' => 'd4c56560-a92c-4631-aa7e-63df448b222a',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/callum.png',
            ],
            6 => [
                'user_id' => 1,
                'name' => 'Carla',
                'avatar_id' => 'cb07d776-f671-4bb1-b601-b4fbdbd0decd',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/carla.png',
            ],
            7 => [
                'user_id' => 1,
                'name' => 'Carlo',
                'avatar_id' => '2267b24a-7a51-44d3-9105-8ff902298549',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/carlo.png',
            ],
            8 => [
                'user_id' => 1,
                'name' => 'Chauncy',
                'avatar_id' => 'd8c88eb6-e7ec-43c1-abd3-1d9293313ed1',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/chauncy.png',
            ],
            9 => [
                'user_id' => 1,
                'name' => 'Chef Collie',
                'avatar_id' => 'fa277266-4a98-4fb7-9001-019f9636a2bf',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/chef_collie.png',
            ],
            10 => [
                'user_id' => 1,
                'name' => 'Daren',
                'avatar_id' => '1add09f4-40d3-40db-b75b-82550747fe8c',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/daren.png',
            ],
            11 => [
                'user_id' => 1,
                'name' => 'Ella',
                'avatar_id' => 'e5d15599-eeb4-488d-8be7-0fba94a52595',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/ella.png',
            ],
            12 => [
                'user_id' => 1,
                'name' => 'Emma',
                'avatar_id' => '2d170992-b042-41d8-bebd-1763cebfbb07',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/emma.png',
            ],
            13 => [
                'user_id' => 1,
                'name' => 'Faiza',
                'avatar_id' => '696b98e6-587a-4e56-bd6e-0f5af9f17164',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/faiza.png',
            ],
            14 => [
                'user_id' => 1,
                'name' => 'Fazwa',
                'avatar_id' => '22ca23a0-44da-4e92-825e-6d7afb717d4d',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/fazwa.png',
            ],
            15 => [
                'user_id' => 1,
                'name' => 'Felix',
                'avatar_id' => '13530b49-6a14-4c22-aa0a-402f2457d142',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/felix.png',
            ],
            16 => [
                'user_id' => 1,
                'name' => 'Francesca',
                'avatar_id' => '4e904b0a-f86d-47be-b654-adc6a6db6511',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/francesca.png',
            ],
            17 => [
                'user_id' => 1,
                'name' => 'Freya',
                'avatar_id' => '93e3dc72-a4ee-4bf9-91a8-ec315ef77d7e',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/freya.png',
            ],
            18 => [
                'user_id' => 1,
                'name' => 'Gary',
                'avatar_id' => 'e90a5e65-84fa-4cd5-b193-aecccc9ea0ca',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/gary.png',
            ],
            19 => [
                'user_id' => 1,
                'name' => 'Helia',
                'avatar_id' => 'e9213f66-948e-45f7-89c5-f3adf1e65904',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/helia.png',
            ],
            20 => [
                'user_id' => 1,
                'name' => 'Ines',
                'avatar_id' => 'a735999c-bd61-4840-8afe-5676aa61c886',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/ines.png',
            ],
            21 => [
                'user_id' => 1,
                'name' => 'Isabella',
                'avatar_id' => 'isabella_costume1_cameraA',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/isabella.png',
            ],
            22 => [
                'user_id' => 1,
                'name' => 'Jack',
                'avatar_id' => '94a2b8a4-f1dc-4d14-808d-24a0cf4ac03c',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/jack.png',
            ],
            23 => [
                'user_id' => 1,
                'name' => 'Jackie',
                'avatar_id' => '099a3571-ad3a-4301-b18b-0280416518f1',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/jackie.png',
            ],
            24 => [
                'user_id' => 1,
                'name' => 'James',
                'avatar_id' => 'james_costume1_cameraA',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/james.png',
            ],
            25 => [
                'user_id' => 1,
                'name' => 'Jaz',
                'avatar_id' => 'a963cf0f-023c-408c-a1df-48c7d6183100',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/jaz.png',
            ],
            26 => [
                'user_id' => 1,
                'name' => 'Jenna',
                'avatar_id' => 'caa22546-7e27-4ebb-ab1e-80981e44701e',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/jenna.png',
            ],
            27 => [
                'user_id' => 1,
                'name' => 'Jimmy',
                'avatar_id' => 'ad669df2-ce3b-4cc4-af61-8a8d09e400a5',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/jimmy.png',
            ],
            28 => [
                'user_id' => 1,
                'name' => 'Jordan',
                'avatar_id' => 'f94037d1-0209-4a46-b2a6-f6579849397d',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/jordan.png',
            ],
            29 => [
                'user_id' => 1,
                'name' => 'Joshua',
                'avatar_id' => '0d2356ca-b688-419a-b08b-9264e5a6a94e',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/joshua.png',
            ],
            30 => [
                'user_id' => 1,
                'name' => 'Julia',
                'avatar_id' => '9fd70b49-1ab4-494e-9872-90d831ad31b7',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/julia.png',
            ],
            31 => [
                'user_id' => 1,
                'name' => 'Julie',
                'avatar_id' => 'ce73d1d1-6422-46d7-8141-f9a156835f14',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/julie.png',
            ],
            32 => [
                'user_id' => 1,
                'name' => 'Juliette',
                'avatar_id' => 'e0ae99d4-54ad-4bb9-892b-a907cf50eafe',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/juliette.png',
            ],
            33 => [
                'user_id' => 1,
                'name' => 'Kade',
                'avatar_id' => '5e7b9416-b8a8-4c79-a64f-4ac02d72fe09',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/kade.png',
            ],
            34 => [
                'user_id' => 1,
                'name' => 'Kayla',
                'avatar_id' => '277766da-bb79-4a75-9193-ed45a03b372e',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/kayla.png',
            ],
            35 => [
                'user_id' => 1,
                'name' => 'Kenzo',
                'avatar_id' => 'c9fa6a2f-a2d6-4526-8d92-a4647e65a6a6',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/kenzo.png',
            ],
            36 => [
                'user_id' => 1,
                'name' => 'Kevin',
                'avatar_id' => 'fe0b0421-8046-491b-ab60-b3e1e2c264ab',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/kevin.png',
            ],
            37 => [
                'user_id' => 1,
                'name' => 'Kiara',
                'avatar_id' => 'f61c0edd-89d1-4a85-a146-af10864f3b3f',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/kiara.png',
            ],
            38 => [
                'user_id' => 1,
                'name' => 'Kira',
                'avatar_id' => '61efd173-95f6-45cf-bfa4-9ac7a58a47b9',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/kira.png',
            ],
            39 => [
                'user_id' => 1,
                'name' => 'Lauren',
                'avatar_id' => '73482c65-e461-476f-8651-47433eaf4327',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/lauren.png',
            ],
            40 => [
                'user_id' => 1,
                'name' => 'Liam',
                'avatar_id' => '4fcc5091-18b4-4dc2-a1ae-f028170fdf0d',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/liam.png',
            ],
            41 => [
                'user_id' => 1,
                'name' => 'Lisa',
                'avatar_id' => '34af91b2-95af-4994-852e-5472afc640a2',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/lisa.png',
            ],
            42 => [
                'user_id' => 1,
                'name' => 'Lois',
                'avatar_id' => '58f584ed-a453-4c12-a484-2b174c4bbe1b',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/lois.png',
            ],
            43 => [
                'user_id' => 1,
                'name' => 'Lola',
                'avatar_id' => 'a2a42b3c-dfab-45f3-9e2a-3a8112c0ef63',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/lola.png',
            ],
            44 => [
                'user_id' => 1,
                'name' => 'Luna',
                'avatar_id' => 'a73b4614-d021-48aa-a86c-ecfc3934390a',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/luna.png',
            ],
            45 => [
                'user_id' => 1,
                'name' => 'Marcus',
                'avatar_id' => 'marcus_costume1_cameraA',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/marcus.png',
            ],
            46 => [
                'user_id' => 1,
                'name' => 'Mario',
                'avatar_id' => '18784ae4-0a1e-43a5-9f78-a1a8bbfeb360',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/mario.png',
            ],
            47 => [
                'user_id' => 1,
                'name' => 'Matt',
                'avatar_id' => 'd4929d65-1644-4a57-85dc-bee35e9ef29e',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/matt.png',
            ],
            48 => [
                'user_id' => 1,
                'name' => 'Monica',
                'avatar_id' => '772d31e3-be24-4089-8a76-c50623014556',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/monica.png',
            ],
            49 => [
                'user_id' => 1,
                'name' => 'Ms Claus',
                'avatar_id' => '422f540c-09db-404e-b4c3-14add80fddfb',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/ms_claus.png',
            ],
            50 => [
                'user_id' => 1,
                'name' => 'Nancy',
                'avatar_id' => 'f9ce6812-ac77-4a58-a285-995216257386',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/nancy.png',
            ],
            51 => [
                'user_id' => 1,
                'name' => 'Natalie',
                'avatar_id' => '92bfa0c7-bd1f-45c8-9811-3fd7ba6e5f2e',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/natalie.png',
            ],
            52 => [
                'user_id' => 1,
                'name' => 'Nicole',
                'avatar_id' => 'adac13c2-cd91-4422-9e28-642f972c72f0',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/nicole.png',
            ],
            53 => [
                'user_id' => 1,
                'name' => 'Noah',
                'avatar_id' => '822e19d7-fdad-4ad9-a84e-c910f8ba9939',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/noah.png',
            ],
            54 => [
                'user_id' => 1,
                'name' => 'Olivia',
                'avatar_id' => 'ffd62308-2e22-4402-ab23-92eb62c73d0b',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/olivia.png',
            ],
            55 => [
                'user_id' => 1,
                'name' => 'Paloma',
                'avatar_id' => '65cdfcde-095f-416f-af6c-01cf377b542a',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/paloma.png',
            ],
            56 => [
                'user_id' => 1,
                'name' => 'Paul',
                'avatar_id' => 'ea86aeb9-13d3-4ae8-8d09-f0f5f4a4ac11',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/paul.png',
            ],
            57 => [
                'user_id' => 1,
                'name' => 'Pierre',
                'avatar_id' => 'd85116be-e277-46ab-8e0e-eef4f9976f9d',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/pierre.png',
            ],
            58 => [
                'user_id' => 1,
                'name' => 'Ponn',
                'avatar_id' => '546f9c34-511b-487e-b295-891303627288',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/ponn.png',
            ],
            59 => [
                'user_id' => 1,
                'name' => 'Rosie',
                'avatar_id' => 'b5b98fa1-bb55-41f6-a474-7cfadba0dcdc',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/rosie.png',
            ],
            60 => [
                'user_id' => 1,
                'name' => 'Sal',
                'avatar_id' => 'f398869d-1375-4f35-858a-6d26c46b5e40',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/sal.png',
            ],
            61 => [
                'user_id' => 1,
                'name' => 'Samuel',
                'avatar_id' => 'b3a593e8-fef1-4786-ba26-46341cec828a',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/samuel.png',
            ],
            62 => [
                'user_id' => 1,
                'name' => 'Sana',
                'avatar_id' => '4095cd7c-40ab-4134-9c76-80f07c845b31',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/sana.png',
            ],
            63 => [
                'user_id' => 1,
                'name' => 'Santa',
                'avatar_id' => 'santa_costume1_cameraA',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/santa.png',
            ],
            64 => [
                'user_id' => 1,
                'name' => 'Sia',
                'avatar_id' => '937df128-06f4-40c9-b97a-204656a03fd0',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/sia.png',
            ],
            65 => [
                'user_id' => 1,
                'name' => 'Sydonie',
                'avatar_id' => 'd8441fa0-0514-4cab-90c7-626ab205e025',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/sydonie.png',
            ],
            66 => [
                'user_id' => 1,
                'name' => 'Talia',
                'avatar_id' => 'b3d74452-7011-4e8e-b3bf-12f7406f8f22',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/talia.png',
            ],
            67 => [
                'user_id' => 1,
                'name' => 'Theresa',
                'avatar_id' => '7dcff88c-786e-4d9a-83f6-75046ffc4b2d',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/theresa.png',
            ],
            68 => [
                'user_id' => 1,
                'name' => 'Thomas',
                'avatar_id' => 'c328313e-1d7f-49d6-9558-3dd14f969ebc',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/thomas.png',
            ],
            69 => [
                'user_id' => 1,
                'name' => 'Tilly',
                'avatar_id' => 'e6ec1498-bc95-4bdf-b187-53d8c2af401b',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/tilly.png',
            ],
            70 => [
                'user_id' => 1,
                'name' => 'Timothy',
                'avatar_id' => '36af884a-5333-4681-8bb5-55fb7ea3a89c',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/timothy.png',
            ],
            71 => [
                'user_id' => 1,
                'name' => 'Tony',
                'avatar_id' => 'cf46c1b6-e0ca-4be4-af97-b89aaa73a028',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/tony.png',
            ],
            72 => [
                'user_id' => 1,
                'name' => 'Veronika',
                'avatar_id' => 'veronika_costume1_cameraA',
                'gender' => 'Female',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/veronika.png',
            ],
            73 => [
                'user_id' => 1,
                'name' => 'Will',
                'avatar_id' => 'e2537805-4bd9-4062-aa97-670e7fe5ca6e',
                'gender' => 'Male',
                'type' => 'ai_avatar',
                'status' => 'Active',
                'provider' => 'synthesia',
                'img_url' => 'Modules/Synthesia/Resources/assets/avatars/will.png',
            ],
        ];

        
        foreach ($avatarsWithImage as $avatar) {

            if (Avatar::where('avatar_id', $avatar['avatar_id'])->exists()) {
                continue;
            }
            
            $insertedAvatar = Avatar::create(
                [
                    'user_id' => $avatar['user_id'],
                    'name' => $avatar['name'],
                    'avatar_id' => $avatar['avatar_id'],
                    'gender' => $avatar['gender'],
                    'type' => 'ai_avatar',
                    'status' => 'Active',
                    'provider' => 'synthesia',
                ]
            );


            \DB::table('avatar_metas')->insert(array (

                'owner_type' => 'Modules\\OpenAI\\Entities\\Avatar',
                'owner_id' => $insertedAvatar->id,
                'type' => 'string',
                'key' => 'image_url',
                'value' => url($avatar['img_url']),
            ));

        }
        
    }
}
