<?php

namespace Modules\Dummy\Database\Seeders\Modules\OpenAI\versions\v5_8_0;

use Illuminate\Database\Seeder;
use DB;
use stdClass;

class ArchivesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {

        $archive = DB::table('archives')->where('unique_identifier', '184707d9-7471-481f-b357-4f4f445aadf8')->first();

        if (!$archive) {
            $archiveId1 = DB::table('archives')->insertGetId(
                [
                    'parent_id' => NULL,
                    'user_id' => 1,
                    'title' => 'A cinematic shot of a young woman standing on a cliff during golden hour wind blowing through her hair overlooking the ocean The camera slowly pans in with dramatic lighting and a filmlike texture',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => '0',
                    'unique_identifier' => '184707d9-7471-481f-b357-4f4f445aadf8',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Completed',
                ],
            );

            $archiveId2 = DB::table('archives')->insertGetId(
                [
                    'parent_id' => $archiveId1,
                    'user_id' => NULL,
                    'title' => NULL,
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => '',
                    'provider' => NULL,
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video_chat',
                    'status' => 'Active',
                ],
            );

            DB::table('archives_meta')->insert(array (
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'string',
                    'key' => 'file_name',
                    'value' => 'A cinematic shot of a young woman standing on a cliff during golden hour wind blowing through her hair overlooking the ocean The camera slowly pans in with dramatic lighting and a filmlike texture',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => 'A cinematic shot of a young woman standing on a cliff during golden hour wind blowing through her hair overlooking the ocean The camera slowly pans in with dramatic lighting and a filmlike texture',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'string',
                    'key' => 'file_id',
                    'value' => '2980e3fa-e0c3-43de-925e-4958fe4dd756',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'array',
                    'key' => 'videos_url',
                    'value' => '["20250828\\\\7719a357fb27c024e515ef38751ac154.mp4"]',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"model":"kling-video-v1-standard","aspect_ratio":"16:9","duration":"5","camera_control":"down_back","service":"text-to-video"}',
                ),
            ));

            $archiveId3 = DB::table('archives')->insertGetId(
                [
                    'parent_id' => $archiveId2,
                    'user_id' => 1,
                    'title' => 'A cinematic shot of a young woman standing on a cliff during golden hour wind blowing through her hair overlooking the ocean The camera slowly pans in with dramatic lighting and a filmlike texture',
                    'content' => NULL,
                    'filtered_content' => NULL,
                    'raw_response' => NULL,
                    'unique_identifier' => 'da91df4b-3706-4fb0-a499-4323f89e3794',
                    'provider' => 'falai',
                    'expense' => NULL,
                    'expense_type' => NULL,
                    'type' => 'text_to_video',
                    'status' => 'Completed',
                ],
            );

            DB::table('archives_meta')->insert(array (
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 3,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"model":"kling-video-v1-standard","aspect_ratio":"16:9","duration":"5","camera_control":"down_back","service":"text-to-video"}',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 3,
                    'type' => 'string',
                    'key' => 'file_name',
                    'value' => '20250828\\7719a357fb27c024e515ef38751ac154.mp4',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 3,
                    'type' => 'integer',
                    'key' => 'video_creator_id',
                    'value' => '1',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 3,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'a-cinematic-shot-of-a-young-woman-standing-on-a-cliff-during-golden-hour-wind-blowing-through-her-hair-overlooking-the-o',
                ),
            ));
        }

        $image1 = DB::table('archives')->where('unique_identifier', '2bfeed11-7886-4c27-9e71-a84cd260cbac')->first();

        if (!$image1) {
            $imagheId1 = DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'A photorealistic image of a cyberpunk city at night glowing neon signs in blue and pink with flying cars zooming between skyscrapers The streets below are wet from rain reflecting the neon lights The mood is futuristic and bustling with dramatic contrast between light and shadow',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => '2bfeed11-7886-4c27-9e71-a84cd260cbac',
                'provider' => NULL,
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image',
                'status' => 'Active',
            ]);
            DB::table('archives_meta')->insert(array (
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $imagheId1,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => '["public\\\\uploads\\\\aiImages\\\\d3fc7906e849fbf9e1d8358832abe967.png"]',
                ),
                
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $imagheId1,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"gemini-2.5-flash-image-preview","variant":"1","art_style":"3D Model","light_effect":"Normal"}',
                ),
            ));

            $imagheId2 = DB::table('archives')->insertGetId([
                'parent_id' => $imagheId1,
                'user_id' => 1,
                'title' => 'A photorealistic image of a cyberpunk city at night glowing neon signs in blue and pink with flying cars zooming between skyscrapers The streets below are wet from rain reflecting the neon lights The mood is futuristic and bustling with dramatic contrast between light and shadow',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => '179824fd-787d-45d1-a281-7ec4c9d2a552',
                'provider' => NULL,
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert(array (
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $imagheId2,
                    'type' => 'string',
                    'key' => 'user_reply',
                    'value' => 'A photorealistic image of a cyberpunk city at night glowing neon signs in blue and pink with flying cars zooming between skyscrapers The streets below are wet from rain reflecting the neon lights The mood is futuristic and bustling with dramatic contrast between light and shadow',
                ),
            ));

            $imagheId3 = DB::table('archives')->insertGetId([
                'parent_id' => $imagheId2,
                'user_id' => NULL,
                'title' => 'A photorealistic image of a cyberpunk city at night glowing neon signs in blue and pink with flying cars zooming between skyscrapers The streets below are wet from rain reflecting the neon lights The mood is futuristic and bustling with dramatic contrast between light and shadow',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => 'e71279b1-8296-4d01-b5f4-f808136fc6c9',
                'provider' => 'gemini',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert(array (
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $imagheId3,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => '["public\\\\uploads\\\\aiImages\\\\d3fc7906e849fbf9e1d8358832abe967.png"]',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $imagheId3,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"gemini-2.5-flash-image-preview","variant":"1","art_style":"3D Model","light_effect":"Normal"}',
                ),
            ));
            $imagheId4 = DB::table('archives')->insertGetId([
                'parent_id' => $imagheId3,
                'user_id' => NULL,
                'title' => 'A photorealistic image of a cyberpunk city at night glowing neon signs in blue and pink with flying cars zooming between skyscrapers The streets below are wet from rain reflecting the neon lights The mood is futuristic and bustling with dramatic contrast between light and shadow',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => '1180fe1a-5f1d-4e06-bfa9-064aa71794d0',
                'provider' => 'gemini',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert(array (
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 7,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\d3fc7906e849fbf9e1d8358832abe967.png',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 7,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => 'd3fc7906e849fbf9e1d8358832abe967.png',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 7,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'a-photorealistic-image-of-a-cyberpunk-city-at-night-glowing-neon-signs-in-blue-and-pink-with-flying-cars-zooming-between',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 7,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => '1',
                ),
                array (
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => 7,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"gemini-2.5-flash-image-preview","variant":"1","art_style":"3D Model","light_effect":"Normal"}',
                ),
            ));
        }

        $image2 = DB::table('archives')->where('unique_identifier', '7118d8fd-159e-4326-9132-21e33fa366da')->first();

        if (!$image2) {

            $imagheId1 = DB::table('archives')->insertGetId([
                'parent_id' => NULL,
                'user_id' => 1,
                'title' => 'Ultrarealistic portrait of a young woman with sunlight on her face cinematic lighting photorealistic',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => '7118d8fd-159e-4326-9132-21e33fa366da',
                'provider' => NULL,
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\e6d650e51bb4f9ddae8e0f079a4810cd.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);


            $imagheId2 = DB::table('archives')->insertGetId([
                'parent_id' => $imagheId1,
                'user_id' => 1,
                'title' => 'Ultrarealistic portrait of a young woman with sunlight on her face cinematic lighting photorealistic',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => 'f44be48e-39af-4d16-ad17-8fa7f80485c7',
                'provider' => NULL,
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Ultrarealistic portrait of a young woman with sunlight on her face cinematic lighting photorealistic',
                ],
            ]);


            $imagheId3 = DB::table('archives')->insertGetId([
                'parent_id' => $imagheId1,
                'user_id' => NULL,
                'title' => 'Ultrarealistic portrait of a young woman with sunlight on her face cinematic lighting photorealistic',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => '869d39e3-41fb-4848-9563-22fee4a85962',
                'provider' => 'stabilityai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\e6d650e51bb4f9ddae8e0f079a4810cd.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);


            $imagheId4 = DB::table('archives')->insertGetId([
                'parent_id' => $imagheId3,
                'user_id' => NULL,
                'title' => 'Ultrarealistic portrait of a young woman with sunlight on her face cinematic lighting photorealistic',
                'content' => NULL,
                'filtered_content' => NULL,
                'raw_response' => NULL,
                'unique_identifier' => '17b927c1-38c0-47cb-86dd-7dc8fa91a7e4',
                'provider' => 'stabilityai',
                'expense' => NULL,
                'expense_type' => NULL,
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\e6d650e51bb4f9ddae8e0f079a4810cd.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'e6d650e51bb4f9ddae8e0f079a4810cd.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'ultrarealistic-portrait-of-a-young-woman-with-sunlight-on-her-face-cinematic-lighting-photorealistic',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => '1',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imagheId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);
        }


        $image3 = DB::table('archives')->where('unique_identifier', '6dbb0b16-8a8b-4df3-9476-712d253745d0')->first();

        if (!$image3) {
            $imageId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Fantasy warrior elf with silver hair and glowing blue eyes ornate armor mystical forest highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '6dbb0b16-8a8b-4df3-9476-712d253745d0',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\0f0e4e64388a39af98df88a44764c81f.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-large","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1","negative_prompt":"blurry, low quality, pixelated, deformed, poorly drawn, ugly, unrealistic anatomy, bad proportions, extra limbs, cartoonish, messy background, out of focus, overexposed, underexposed, monochrome, modern clothing, casual outfit"}',
                ],
            ]);

            $imageId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => 1,
                'title'            => 'Fantasy warrior elf with silver hair and glowing blue eyes ornate armor mystical forest highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '447ee266-3da0-4466-8322-0e5dd663fef8',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Fantasy warrior elf with silver hair and glowing blue eyes ornate armor mystical forest highly detailed',
                ],
            ]);

            $imageId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => null,
                'title'            => 'Fantasy warrior elf with silver hair and glowing blue eyes ornate armor mystical forest highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd835ea82-1661-4154-b5f0-eddab6a3fbbb',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\0f0e4e64388a39af98df88a44764c81f.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-large","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1","negative_prompt":"blurry, low quality, pixelated, deformed, poorly drawn, ugly, unrealistic anatomy, bad proportions, extra limbs, cartoonish, messy background, out of focus, overexposed, underexposed, monochrome, modern clothing, casual outfit"}',
                ],
            ]);

            $imageId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId3,
                'user_id'          => null,
                'title'            => 'Fantasy warrior elf with silver hair and glowing blue eyes ornate armor mystical forest highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '2b2cb5c4-d87a-4d69-b93b-62d4630e42c8',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\0f0e4e64388a39af98df88a44764c81f.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '0f0e4e64388a39af98df88a44764c81f.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'fantasy-warrior-elf-with-silver-hair-and-glowing-blue-eyes-ornate-armor-mystical-forest-highly-detailed',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => '1',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-large","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1","negative_prompt":"blurry, low quality, pixelated, deformed, poorly drawn, ugly, unrealistic anatomy, bad proportions, extra limbs, cartoonish, messy background, out of focus, overexposed, underexposed, monochrome, modern clothing, casual outfit"}',
                ],
            ]);


        }

        $image4 = DB::table('archives')->where('unique_identifier', '5c45b5ec-4b29-422b-8fda-79ca5feaa6bf')->first();

        if (!$image4) {
            // 1) Insert main archive (id = 16)
            $imageId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Majestic mountain landscape at sunrise misty valleys vivid sky photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '5c45b5ec-4b29-422b-8fda-79ca5feaa6bf',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\29e8f2f5eb083e84639fc1e30acb1848.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-medium","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1","negative_prompt":"blurry, low quality, pixelated, deformed, messy background, out of focus"}',
                ],
            ]);

            // 2) Insert child archive (id = 17)
            $imageId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => 1,
                'title'            => 'Majestic mountain landscape at sunrise misty valleys vivid sky photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '6b380f0b-2c5d-4960-a0de-71eab6ae32f3',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Majestic mountain landscape at sunrise misty valleys vivid sky photorealistic',
                ],
            ]);

            // 3) Insert AI response archive (id = 18)
            $imageId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => null,
                'title'            => 'Majestic mountain landscape at sunrise misty valleys vivid sky photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '183f2088-e6af-49cc-b01e-e70b88270fab',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\29e8f2f5eb083e84639fc1e30acb1848.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-medium","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1","negative_prompt":"blurry, low quality, pixelated, deformed, messy background, out of focus"}',
                ],
            ]);

            // 4) Insert image variant archive (id = 19)
            $imageId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId3,
                'user_id'          => null,
                'title'            => 'Majestic mountain landscape at sunrise misty valleys vivid sky photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd08527c2-19ad-4164-a21a-bf8fcc009fe3',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\29e8f2f5eb083e84639fc1e30acb1848.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '29e8f2f5eb083e84639fc1e30acb1848.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'majestic-mountain-landscape-at-sunrise-misty-valleys-vivid-sky-photorealistic',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => '1',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-medium","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1","negative_prompt":"blurry, low quality, pixelated, deformed, messy background, out of focus"}',
                ],
            ]);

        }

        $image5 = DB::table('archives')->where('unique_identifier', '7986f77c-f6fd-4941-9c0a-4e6bc4aa3331')->first();

        if (!$image5) {
            // 1) Insert main archive (id = 28)
            $imageId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Tiny construction workers cutting open a giant apple using cranes and tools to lift slices Dirt and leaves on the ground cinematic golden lighting ultra detailed miniature world whimsical but realistic macro photography',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '7986f77c-f6fd-4941-9c0a-4e6bc4aa3331',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\b8856b8c2c705123f336f4092ae6f0bd.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

            // 2) Insert child archive (id = 29)
            $imageId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => 1,
                'title'            => 'Tiny construction workers cutting open a giant apple using cranes and tools to lift slices Dirt and leaves on the ground cinematic golden lighting ultra detailed miniature world whimsical but realistic macro photography',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd6dd0e95-0ce5-47a9-86b1-1e3540f18d96',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Tiny construction workers cutting open a giant apple using cranes and tools to lift slices Dirt and leaves on the ground cinematic golden lighting ultra detailed miniature world whimsical but realistic macro photography',
                ],
            ]);

            // 3) Insert AI response archive (id = 30)
            $imageId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => null,
                'title'            => 'Tiny construction workers cutting open a giant apple using cranes and tools to lift slices Dirt and leaves on the ground cinematic golden lighting ultra detailed miniature world whimsical but realistic macro photography',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'e4cddc33-a368-404e-a0e4-a0fa9dcfefed',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\b8856b8c2c705123f336f4092ae6f0bd.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

            // 4) Insert image variant archive (id = 31)
            $imageId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId3,
                'user_id'          => null,
                'title'            => 'Tiny construction workers cutting open a giant apple using cranes and tools to lift slices Dirt and leaves on the ground cinematic golden lighting ultra detailed miniature world whimsical but realistic macro photography',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '068dce90-3a50-473c-85fd-a89ab3d18021',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\b8856b8c2c705123f336f4092ae6f0bd.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'b8856b8c2c705123f336f4092ae6f0bd.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'tiny-construction-workers-cutting-open-a-giant-apple-using-cranes-and-tools-to-lift-slices-dirt-and-leaves-on-the-ground',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

        }

        $image6 = DB::table('archives')->where('unique_identifier', '40496d34-08f4-4719-abd2-a6102c66fe98')->first();

        if (!$image6) {
            // 1) Insert main archive (id = 32)
            $imageId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Hyper realistic photograph 8k UHD HDR macro wideangle lens a massive tree in the middle of a field but its trunk and branches are made entirely of transparent crystal glass The sunset light passes through scattering rainbows across the grass Ultra photorealistic surreal but natural breathtaking atmosphere',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '40496d34-08f4-4719-abd2-a6102c66fe98',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\2e5a046fb796a0614b6783605a149563.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

            // 2) Insert child archive (id = 33)
            $imageId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => 1,
                'title'            => 'Hyper realistic photograph 8k UHD HDR macro wideangle lens a massive tree in the middle of a field but its trunk and branches are made entirely of transparent crystal glass The sunset light passes through scattering rainbows across the grass Ultra photorealistic surreal but natural breathtaking atmosphere',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '54d70f69-7a5f-4827-b375-eed52a25322c',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Hyper realistic photograph 8k UHD HDR macro wideangle lens a massive tree in the middle of a field but its trunk and branches are made entirely of transparent crystal glass The sunset light passes through scattering rainbows across the grass Ultra photorealistic surreal but natural breathtaking atmosphere',
                ],
            ]);

            // 3) Insert AI response archive (id = 34)
            $imageId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => null,
                'title'            => 'Hyper realistic photograph 8k UHD HDR macro wideangle lens a massive tree in the middle of a field but its trunk and branches are made entirely of transparent crystal glass The sunset light passes through scattering rainbows across the grass Ultra photorealistic surreal but natural breathtaking atmosphere',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '5385e743-5d06-4645-8af8-21913e789766',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\2e5a046fb796a0614b6783605a149563.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

            // 4) Insert image variant archive (id = 35)
            $imageId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId3,
                'user_id'          => null,
                'title'            => 'Hyper realistic photograph 8k UHD HDR macro wideangle lens a massive tree in the middle of a field but its trunk and branches are made entirely of transparent crystal glass The sunset light passes through scattering rainbows across the grass Ultra photorealistic surreal but natural breathtaking atmosphere',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'f4bd73f0-f47e-459e-abb0-3f736afbed7a',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\2e5a046fb796a0614b6783605a149563.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '2e5a046fb796a0614b6783605a149563.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'hyper-realistic-photograph-8k-uhd-hdr-macro-wideangle-lens-a-massive-tree-in-the-middle-of-a-field-but-its-trunk-and-bra',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

        }

        $image7 = DB::table('archives')->where('unique_identifier', '46b0d168-cb1d-4ed0-b14d-6ad4c7c254bc')->first();

        if (! $image7) {
            // 1) Insert main archive (id = 36)
            $imageId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Photorealistic image of a capybara knitting a small handmade doll cozy setting highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '46b0d168-cb1d-4ed0-b14d-6ad4c7c254bc',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\ee17327efa2f4205bc1839c1e52352e3.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-medium","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
            ]);

            // 2) Insert child archive (id = 37)
            $imageId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => 1,
                'title'            => 'Photorealistic image of a capybara knitting a small handmade doll cozy setting highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '9f935daf-fdfa-4a2b-aa75-5961b4bfa358',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Photorealistic image of a capybara knitting a small handmade doll cozy setting highly detailed',
                ],
            ]);

            // 3) Insert AI response archive (id = 38)
            $imageId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $imageId1,
                'user_id'          => null,
                'title'            => 'Photorealistic image of a capybara knitting a small handmade doll cozy setting highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '43eb1418-3b92-48d7-9d2b-eca316e1a9b9',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\ee17327efa2f4205bc1839c1e52352e3.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-medium","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
            ]);

            // 4) Insert additional main archive (id = 40, Gemini model)
            $imageId4 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Photorealistic image of a capybara knitting a small handmade doll cozy setting highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '981e86dd-a654-4bde-b910-be8d9367d27c',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\6c0d0806f11daa0d23303827d1ef0638.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $imageId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image8 = DB::table('archives')->where('unique_identifier', 'f52589f5-47bd-44c6-9a08-3a087c6217d5')->first();

        if (! $image8) {
            // 1) Main archive (id = 44)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'A very distant wideangle cinematic shot of a surreal enormous colorful beach umbrella fully visible in the frame standing directly beside the volleyball net The umbrella is so huge that it dominates the scene and from the distant perspective the children and volleyball court look small beneath its massive shade All the boys are strictly under the shadow playing beach volleyball barefoot in colorful summer clothes None of them are in direct sunlight The extra distant camera view emphasizes the surreal and colossal scale of the umbrella compared to the kids and the beach Ultrarealistic vibrant summer tones 8K resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'f52589f5-47bd-44c6-9a08-3a087c6217d5',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\dc97af53dbe8ff822e685e108b9404ea.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"Cinematic","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 45)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => $archiveId1,
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'afa0abf5-bc12-4c2d-a213-735e517ddb48',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'A very distant wideangle cinematic shot of a surreal enormous colorful beach umbrella fully visible in the frame standing directly beside the volleyball net The umbrella is so huge that it dominates the scene and from the distant perspective the children and volleyball court look small beneath its massive shade All the boys are strictly under the shadow playing beach volleyball barefoot in colorful summer clothes None of them are in direct sunlight The extra distant camera view emphasizes the surreal and colossal scale of the umbrella compared to the kids and the beach Ultrarealistic vibrant summer tones 8K resolution',
                ],
            ]);

            // 3) AI response archive (id = 46)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => $archiveId1,
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '22dce8fa-fdb9-4288-a8e9-583b059aa375',
                'provider'         => 'gemini',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\dc97af53dbe8ff822e685e108b9404ea.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"Cinematic","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 47)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => $archiveId1,
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '8a4073b2-52d0-453d-8c16-d9de80917cba',
                'provider'         => 'gemini',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\dc97af53dbe8ff822e685e108b9404ea.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'dc97af53dbe8ff822e685e108b9404ea.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'a-very-distant-wideangle-cinematic-shot-of-a-surreal-enormous-colorful-beach-umbrella-fully-visible-in-the-frame-standin',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"Cinematic","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image9 = DB::table('archives')->where('unique_identifier', '24c8f0fd-d6e5-470e-ae2a-3cb524e20ef3')->first();

        if (! $image9) {
            // 1) Main archive (id = 48)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Vintage leatherbound book on desk candlelight casting shadows cozy 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '24c8f0fd-d6e5-470e-ae2a-3cb524e20ef3',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\0c0215d9c0aa2677e79c530f5760d405.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-large","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 49)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Vintage leatherbound book on desk candlelight casting shadows cozy 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'f54b9cba-d218-40ba-b515-2450ae123576',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Vintage leatherbound book on desk candlelight casting shadows cozy 8k',
                ],
            ]);

            // 3) AI response archive (id = 50)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Vintage leatherbound book on desk candlelight casting shadows cozy 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '308abf6b-072a-4741-a72b-a245aff5759e',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\0c0215d9c0aa2677e79c530f5760d405.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-large","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 51)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Vintage leatherbound book on desk candlelight casting shadows cozy 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd02659c0-361a-4e48-9e09-1389651d5a7e',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\0c0215d9c0aa2677e79c530f5760d405.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '0c0215d9c0aa2677e79c530f5760d405.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'vintage-leatherbound-book-on-desk-candlelight-casting-shadows-cozy-8k',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-large","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image10 = DB::table('archives')->where('unique_identifier', 'd4a8350d-f2c0-4699-8871-e95b109bf911')->first();

        if (! $image10 ) {
            // 1) Main archive (id = 56)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Professional headshot of an elderly woman with wrinkles and silver hair soft natural lighting realistic skin texture high detail 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd4a8350d-f2c0-4699-8871-e95b109bf911',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\5b7c30404f7b5e1ae38e98608e388ccc.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-ultra","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 57)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Professional headshot of an elderly woman with wrinkles and silver hair soft natural lighting realistic skin texture high detail 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'e47a4d04-44e6-4e56-8e1b-f4b6d1c6af03',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Professional headshot of an elderly woman with wrinkles and silver hair soft natural lighting realistic skin texture high detail 8k resolution',
                ],
            ]);

            // 3) AI response archive (id = 58)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Professional headshot of an elderly woman with wrinkles and silver hair soft natural lighting realistic skin texture high detail 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '1932465a-b624-45ca-85b9-7ddb4b68c92d',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\5b7c30404f7b5e1ae38e98608e388ccc.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-ultra","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 59)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Professional headshot of an elderly woman with wrinkles and silver hair soft natural lighting realistic skin texture high detail 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'f063c741-bc07-4299-a8d4-ef786f550578',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\5b7c30404f7b5e1ae38e98608e388ccc.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '5b7c30404f7b5e1ae38e98608e388ccc.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'professional-headshot-of-an-elderly-woman-with-wrinkles-and-silver-hair-soft-natural-lighting-realistic-skin-texture-hig',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-ultra","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image11 = DB::table('archives')->where('unique_identifier', '53e034a4-327c-486c-a02f-933cb38105cc')->first();

        if (! $image11) {
            // 1) Main archive (id = 60)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Street photography of a woman crossing a rainy city street at night neon reflections on wet pavement cinematic realism highly detailed full body shot',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '53e034a4-327c-486c-a02f-933cb38105cc',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\ae3f9e1bd3399bb5157e2b093f93327a.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-ultra","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 61)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Street photography of a woman crossing a rainy city street at night neon reflections on wet pavement cinematic realism highly detailed full body shot',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '547e79b9-39c1-4c49-9773-b33e5770722f',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Street photography of a woman crossing a rainy city street at night neon reflections on wet pavement cinematic realism highly detailed full body shot',
                ],
            ]);

            // 3) AI response archive (id = 62)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Street photography of a woman crossing a rainy city street at night neon reflections on wet pavement cinematic realism highly detailed full body shot',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '6de6c26b-c7ca-4cdf-a933-fbd467a5e37c',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\ae3f9e1bd3399bb5157e2b093f93327a.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-ultra","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 63)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Street photography of a woman crossing a rainy city street at night neon reflections on wet pavement cinematic realism highly detailed full body shot',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '4cea5977-8620-4772-b267-88332aa37aec',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\ae3f9e1bd3399bb5157e2b093f93327a.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'ae3f9e1bd3399bb5157e2b093f93327a.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'street-photography-of-a-woman-crossing-a-rainy-city-street-at-night-neon-reflections-on-wet-pavement-cinematic-realism-h',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-ultra","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image12 = DB::table('archives')->where('unique_identifier', '74ea1ae4-12a3-458b-a014-961b084e32b2')->first();

        if (! $image12) {
            // 1) Main archive (id = 64)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Realistic photo of a dense rainforest with mist between tall trees sunlight filtering through leaves ultradetailed textures of bark and moss',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '74ea1ae4-12a3-458b-a014-961b084e32b2',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\23fb120c645858b22976d739b908d617.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 65)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Realistic photo of a dense rainforest with mist between tall trees sunlight filtering through leaves ultradetailed textures of bark and moss',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '5413c8af-dcc3-45e6-b3ee-dcff189b3e21',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Realistic photo of a dense rainforest with mist between tall trees sunlight filtering through leaves ultradetailed textures of bark and moss',
                ],
            ]);

            // 3) AI response archive (id = 66)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Realistic photo of a dense rainforest with mist between tall trees sunlight filtering through leaves ultradetailed textures of bark and moss',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '7c829d4e-1d80-4a8b-99fc-40b24ad591b1',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\23fb120c645858b22976d739b908d617.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 67)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Realistic photo of a dense rainforest with mist between tall trees sunlight filtering through leaves ultradetailed textures of bark and moss',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '4a4f6d6c-8d54-469e-a475-a5231f984834',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\23fb120c645858b22976d739b908d617.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '23fb120c645858b22976d739b908d617.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'realistic-photo-of-a-dense-rainforest-with-mist-between-tall-trees-sunlight-filtering-through-leaves-ultradetailed-textu',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image13 = DB::table('archives')->where('unique_identifier', '82c02c71-93f8-4252-b78a-7ade6e3dcc0a')->first();

        if (! $image13) {
            // 1) Main archive (id = 68)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Closeup of a honeybee on a sunflower detailed wings and pollen macro photography style extremely realisti',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '82c02c71-93f8-4252-b78a-7ade6e3dcc0a',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\5d3ba82e5a10a4f6300dc06230a06bac.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-core","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
            ]);

            // 2) User chat archive (id = 69)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Closeup of a honeybee on a sunflower detailed wings and pollen macro photography style extremely realisti',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '3bc2a83b-39b1-4674-abda-bf1ff3419437',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Closeup of a honeybee on a sunflower detailed wings and pollen macro photography style extremely realisti',
                ],
            ]);

            // 3) AI response archive (id = 70)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Closeup of a honeybee on a sunflower detailed wings and pollen macro photography style extremely realisti',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '90289b65-f1cc-4917-996e-cddd903514c9',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\5d3ba82e5a10a4f6300dc06230a06bac.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-core","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
            ]);

            // 4) Variant archive (id = 71)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Closeup of a honeybee on a sunflower detailed wings and pollen macro photography style extremely realisti',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'c35877d8-d871-401e-bd6a-4ae84f83990c',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\5d3ba82e5a10a4f6300dc06230a06bac.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '5d3ba82e5a10a4f6300dc06230a06bac.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'closeup-of-a-honeybee-on-a-sunflower-detailed-wings-and-pollen-macro-photography-style-extremely-realisti',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd-core","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
            ]);
        }

        $image14 = DB::table('archives')->where('unique_identifier', '1c7a2c5d-308f-4218-ba2f-888a1c1286c3')->first();

        if (! $image14) {
            // 1) Main archive (id = 76)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Rustic kitchen table with fresh bread fruits and cheese natural window light photorealistic textures 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '1c7a2c5d-308f-4218-ba2f-888a1c1286c3',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\de146ae691d1ee8bc7ed649507622a8e.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1536x640","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

            // 2) User chat archive (id = 77)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Rustic kitchen table with fresh bread fruits and cheese natural window light photorealistic textures 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '460a1fcd-f12d-4d63-8732-1080a34aacc0',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Rustic kitchen table with fresh bread fruits and cheese natural window light photorealistic textures 8k resolution',
                ],
            ]);

            // 3) AI response archive (id = 78)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Rustic kitchen table with fresh bread fruits and cheese natural window light photorealistic textures 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '6279a9f8-0d1a-429b-b5e2-bc5c122672e3',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\de146ae691d1ee8bc7ed649507622a8e.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1536x640","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

            // 4) Variant archive (id = 79)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Rustic kitchen table with fresh bread fruits and cheese natural window light photorealistic textures 8k resolution',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'b7fae0ee-063b-4853-bcb8-bbe727fa54db',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\de146ae691d1ee8bc7ed649507622a8e.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'de146ae691d1ee8bc7ed649507622a8e.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'rustic-kitchen-table-with-fresh-bread-fruits-and-cheese-natural-window-light-photorealistic-textures-8k-resolution',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1536x640","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

        }

        $image15 = DB::table('archives')->where('unique_identifier', '3d887d4d-aef5-447f-85ca-8d587edea506')->first();

        if (! $image15) {
            // 1) Main archive (id = 80)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'A person standing atop a lighthouse singing passionately towards the sky for Sora with waves crashing below and the horizon bathed in soft evening light',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '3d887d4d-aef5-447f-85ca-8d587edea506',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\2b1118bdb9333f3ad7fd61847cfdec6e.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-large","variant":"1","art_style":"Cinematic","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 81)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'A person standing atop a lighthouse singing passionately towards the sky for Sora with waves crashing below and the horizon bathed in soft evening light',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '9c291b7c-723d-4061-8c4c-ca1b1ccdfe0f',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'A person standing atop a lighthouse singing passionately towards the sky for Sora with waves crashing below and the horizon bathed in soft evening light',
                ],
            ]);

            // 3) AI response archive (id = 82)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'A person standing atop a lighthouse singing passionately towards the sky for Sora with waves crashing below and the horizon bathed in soft evening light',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '19627a75-e0f8-4384-b2ee-075b7ab1b10d',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\2b1118bdb9333f3ad7fd61847cfdec6e.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-large","variant":"1","art_style":"Cinematic","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 83)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'A person standing atop a lighthouse singing passionately towards the sky for Sora with waves crashing below and the horizon bathed in soft evening light',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '44a7ad54-bf6f-4399-86fb-0f5ed5b4e2f9',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\2b1118bdb9333f3ad7fd61847cfdec6e.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '2b1118bdb9333f3ad7fd61847cfdec6e.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'a-person-standing-atop-a-lighthouse-singing-passionately-towards-the-sky-for-sora-with-waves-crashing-below-and-the-hori',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3-large","variant":"1","art_style":"Cinematic","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);


        }

        $image16 = DB::table('archives')->where('unique_identifier', '14f34fde-b9c6-472d-a46b-9c39f7d2afc0')->first();

        if (! $image16) {
            // 1) Main archive (id = 88)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Astronaut planting a flag on the Moons surface sharp shadows and bright light detailed footprints in the lunar dust photorealistic 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '14f34fde-b9c6-472d-a46b-9c39f7d2afc0',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\fbdba9b62cf376d959c316a488c62211.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 89)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Astronaut planting a flag on the Moons surface sharp shadows and bright light detailed footprints in the lunar dust photorealistic 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'c962da22-bc43-43a8-a62c-9618bc99d73e',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Astronaut planting a flag on the Moons surface sharp shadows and bright light detailed footprints in the lunar dust photorealistic 8k',
                ],
            ]);

            // 3) AI response archive (id = 90)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Astronaut planting a flag on the Moons surface sharp shadows and bright light detailed footprints in the lunar dust photorealistic 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '91a6d89e-9bca-4d5f-b577-898023be3908',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\fbdba9b62cf376d959c316a488c62211.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 91)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Astronaut planting a flag on the Moons surface sharp shadows and bright light detailed footprints in the lunar dust photorealistic 8k',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '5819a7a0-b875-4085-a191-fd0f8dfd4317',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\fbdba9b62cf376d959c316a488c62211.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'fbdba9b62cf376d959c316a488c62211.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'astronaut-planting-a-flag-on-the-moons-surface-sharp-shadows-and-bright-light-detailed-footprints-in-the-lunar-dust-phot',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image17 = DB::table('archives')->where('unique_identifier', 'a99778a4-a89a-4fa7-90f0-91b73ee12f28')->first();

        if (! $image17) {
            // 1) Main archive (id = 92)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Photorealistic image of a tabby cat lying on a cozy blanket soft indoor lighting detailed fur textures sharp focus on the eyes',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'a99778a4-a89a-4fa7-90f0-91b73ee12f28',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\abe1f8bd631d9aaf7602a8be86857566.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 93)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Photorealistic image of a tabby cat lying on a cozy blanket soft indoor lighting detailed fur textures sharp focus on the eyes',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '37a3acfd-beb1-4634-a8e7-9d454b0ecb5e',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Photorealistic image of a tabby cat lying on a cozy blanket soft indoor lighting detailed fur textures sharp focus on the eyes',
                ],
            ]);

            // 3) AI response archive (id = 94)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Photorealistic image of a tabby cat lying on a cozy blanket soft indoor lighting detailed fur textures sharp focus on the eyes',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'fa011f5e-abe1-4363-83ca-5a52f520f819',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\abe1f8bd631d9aaf7602a8be86857566.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 95)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Photorealistic image of a tabby cat lying on a cozy blanket soft indoor lighting detailed fur textures sharp focus on the eyes',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'cd22f51c-8875-483f-a22f-1522ef1350a5',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\abe1f8bd631d9aaf7602a8be86857566.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'abe1f8bd631d9aaf7602a8be86857566.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'photorealistic-image-of-a-tabby-cat-lying-on-a-cozy-blanket-soft-indoor-lighting-detailed-fur-textures-sharp-focus-on-th',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image18 = DB::table('archives')->where('unique_identifier', 'be85bfb2-b2a4-4f1a-98c0-b9dcff80fa73')->first();

        if (! $image18) {
            // 1) Main archive (id = 96)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Photorealistic black cat sitting on a stone wall at night illuminated by soft moonlight strong contrast between light and shadow cinematic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'be85bfb2-b2a4-4f1a-98c0-b9dcff80fa73',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\60f775348b7db2acb81856041422effa.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 97)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Photorealistic black cat sitting on a stone wall at night illuminated by soft moonlight strong contrast between light and shadow cinematic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'dd7108e4-be7c-4120-ae6d-e45284512a0d',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Photorealistic black cat sitting on a stone wall at night illuminated by soft moonlight strong contrast between light and shadow cinematic',
                ],
            ]);

            // 3) AI response archive (id = 98)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Photorealistic black cat sitting on a stone wall at night illuminated by soft moonlight strong contrast between light and shadow cinematic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '34580804-0347-4679-ab8d-bef4b2c23856',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\60f775348b7db2acb81856041422effa.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 99)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Photorealistic black cat sitting on a stone wall at night illuminated by soft moonlight strong contrast between light and shadow cinematic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '5f28e922-a3bf-4e0e-b70a-cec240252edd',
                'provider'         => 'stabilityai',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\60f775348b7db2acb81856041422effa.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '60f775348b7db2acb81856041422effa.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'photorealistic-black-cat-sitting-on-a-stone-wall-at-night-illuminated-by-soft-moonlight-strong-contrast-between-light-an',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"sd3.5-flash","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image19 = DB::table('archives')->where('unique_identifier', '20e07e44-098e-4c55-95ed-9c267753d5b1')->first();

        if (! $image19) {
            // 1) Main archive (id = 108)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Samurai SpiderMan wearing traditional red and black samurai armor with spider web patterns standing in a bamboo forest at dawn cinematic lighting ultradetailed realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '20e07e44-098e-4c55-95ed-9c267753d5b1',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\3a5a41cd1fef60f8068ee27db60a9b3e.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 2) User chat archive (id = 109)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Samurai SpiderMan wearing traditional red and black samurai armor with spider web patterns standing in a bamboo forest at dawn cinematic lighting ultradetailed realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '2fda2d2c-4aa6-47a5-9e96-4b465a264c58',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Samurai SpiderMan wearing traditional red and black samurai armor with spider web patterns standing in a bamboo forest at dawn cinematic lighting ultradetailed realistic',
                ],
            ]);

            // 3) AI response archive (id = 110)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Samurai SpiderMan wearing traditional red and black samurai armor with spider web patterns standing in a bamboo forest at dawn cinematic lighting ultradetailed realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'a22fdd4f-d237-4a0d-b98a-d02fa4cfd003',
                'provider'         => 'gemini',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\3a5a41cd1fef60f8068ee27db60a9b3e.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

            // 4) Variant archive (id = 111)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Samurai SpiderMan wearing traditional red and black samurai armor with spider web patterns standing in a bamboo forest at dawn cinematic lighting ultradetailed realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '31e1cb09-26e7-4569-9be6-c89180fcdcfe',
                'provider'         => 'gemini',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\3a5a41cd1fef60f8068ee27db60a9b3e.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '3a5a41cd1fef60f8068ee27db60a9b3e.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'samurai-spiderman-wearing-traditional-red-and-black-samurai-armor-with-spider-web-patterns-standing-in-a-bamboo-forest-a',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"gemini-2.0-flash-preview-image-generation","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"1:1"}',
                ],
            ]);

        }

        $image20 = DB::table('archives')->where('unique_identifier', 'af9dfb25-88dd-4761-b1fc-352aef1dfc5a')->first();

        if (! $image20) {
            // 1) Main archive (id = 120)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Ultrarealistic cinematic scene of massive floating islands with cascading waterfalls illuminated by a pink and purple sunset sky Detailed rocky cliffs covered in lush green vegetation Realistic water flow with mist rising from the falls Several dragons flying majestically between the islands highly detailed scales and wings dramatic lighting photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'af9dfb25-88dd-4761-b1fc-352aef1dfc5a',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\fb57a3ab58760842fc5f4e8a9783c71c.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

            // 2) User chat archive (id = 121)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Ultrarealistic cinematic scene of massive floating islands with cascading waterfalls illuminated by a pink and purple sunset sky Detailed rocky cliffs covered in lush green vegetation Realistic water flow with mist rising from the falls Several dragons flying majestically between the islands highly detailed scales and wings dramatic lighting photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'c7523ad9-f472-4bac-9b75-041ad1fc8926',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Ultrarealistic cinematic scene of massive floating islands with cascading waterfalls illuminated by a pink and purple sunset sky Detailed rocky cliffs covered in lush green vegetation Realistic water flow with mist rising from the falls Several dragons flying majestically between the islands highly detailed scales and wings dramatic lighting photorealistic',
                ],
            ]);

            // 3) AI response archive (id = 122)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Ultrarealistic cinematic scene of massive floating islands with cascading waterfalls illuminated by a pink and purple sunset sky Detailed rocky cliffs covered in lush green vegetation Realistic water flow with mist rising from the falls Several dragons flying majestically between the islands highly detailed scales and wings dramatic lighting photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '21ec9f3b-8d01-46b1-9c3c-7a4338725ce4',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\fb57a3ab58760842fc5f4e8a9783c71c.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

            // 4) Variant archive (id = 123)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Ultrarealistic cinematic scene of massive floating islands with cascading waterfalls illuminated by a pink and purple sunset sky Detailed rocky cliffs covered in lush green vegetation Realistic water flow with mist rising from the falls Several dragons flying majestically between the islands highly detailed scales and wings dramatic lighting photorealistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd5c4cb98-6dca-4b88-96ec-0d730b097b6e',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\fb57a3ab58760842fc5f4e8a9783c71c.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'fb57a3ab58760842fc5f4e8a9783c71c.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'ultrarealistic-cinematic-scene-of-massive-floating-islands-with-cascading-waterfalls-illuminated-by-a-pink-and-purple-su',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

        }

        $image21 = DB::table('archives')->where('unique_identifier', '9d80213a-1f59-4a1f-8a83-c20172227deb')->first();

        if (! $image21) {
            // 1) Main archive (id = 128)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Dynamic action shot of Samurai SpiderMan fighting multiple ninjas sparks flying rainsoaked streets cinematic and highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '9d80213a-1f59-4a1f-8a83-c20172227deb',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\1e7647f7b59720b241d6fef2b9656429.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

            // 2) User reply archive (id = 129)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Dynamic action shot of Samurai SpiderMan fighting multiple ninjas sparks flying rainsoaked streets cinematic and highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '0c5cdc41-9b64-4f1b-bc34-b0cbce588fb9',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Dynamic action shot of Samurai SpiderMan fighting multiple ninjas sparks flying rainsoaked streets cinematic and highly detailed',
                ],
            ]);

            // 3) AI response archive (id = 130)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Dynamic action shot of Samurai SpiderMan fighting multiple ninjas sparks flying rainsoaked streets cinematic and highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'ae021cad-b739-498c-9001-ca419d06123c',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\1e7647f7b59720b241d6fef2b9656429.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

            // 4) Variant archive (id = 131)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Dynamic action shot of Samurai SpiderMan fighting multiple ninjas sparks flying rainsoaked streets cinematic and highly detailed',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'e653ec00-63ff-4223-a7fa-21d86dbf7fed',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\1e7647f7b59720b241d6fef2b9656429.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '1e7647f7b59720b241d6fef2b9656429.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'dynamic-action-shot-of-samurai-spiderman-fighting-multiple-ninjas-sparks-flying-rainsoaked-streets-cinematic-and-highly1756807900',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

        }

        $image22 = DB::table('archives')->where('unique_identifier', '4447677d-57cc-49c7-8e42-0a4b2d61a39a')->first();

        if (! $image22) {
            // 1) Main archive (id = 132)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Playful kitten chasing a butterfly in a grassy field golden hour sunlight cinematic and realistic detail',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '4447677d-57cc-49c7-8e42-0a4b2d61a39a',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\dcb06e539da1657f2fc3518a7def8d30.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

            // 2) User reply archive (id = 133)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Playful kitten chasing a butterfly in a grassy field golden hour sunlight cinematic and realistic detail',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'e0aba011-5314-440e-b2cd-918e509b0592',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId2,
                    'type'       => 'string',
                    'key'        => 'user_reply',
                    'value'      => 'Playful kitten chasing a butterfly in a grassy field golden hour sunlight cinematic and realistic detail',
                ],
            ]);

            // 3) AI response archive (id = 134)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Playful kitten chasing a butterfly in a grassy field golden hour sunlight cinematic and realistic detail',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '15fe860e-ed6c-4c71-9232-51af55068e8a',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\dcb06e539da1657f2fc3518a7def8d30.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);

            // 4) Variant archive (id = 135)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Playful kitten chasing a butterfly in a grassy field golden hour sunlight cinematic and realistic detail',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'bd339e48-5726-4525-9277-123bb3b6da70',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\dcb06e539da1657f2fc3518a7def8d30.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => 'dcb06e539da1657f2fc3518a7def8d30.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'playful-kitten-chasing-a-butterfly-in-a-grassy-field-golden-hour-sunlight-cinematic-and-realistic-detail',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'array',
                    'key'        => 'generation_options',
                    'value'      => '{"service":"text-to-image","model":"default","size":"1024x1024","art_style":"Normal","light_effect":"Normal"}',
                ],
            ]);


        }

        $image23 = DB::table('archives')->where('unique_identifier', '73d7fdae-1117-49fc-82a4-38ae25dd7fb6')->first();

        if (! $image23) {
            // 1) Main archive (id = 136)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'Group of three playful kittens cuddling together in a basket soft blanket detailed fur highly realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '73d7fdae-1117-49fc-82a4-38ae25dd7fb6',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            // 2) User reply archive (id = 137)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'Group of three playful kittens cuddling together in a basket soft blanket detailed fur highly realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '46d18960-4b2f-47ae-b7fe-be5439b33386',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            // 3) AI response archive (id = 138)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'Group of three playful kittens cuddling together in a basket soft blanket detailed fur highly realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'd28c2d69-ab48-4a97-87ee-3b96c44f0adf',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            // 4) Variant archive (id = 139)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'Group of three playful kittens cuddling together in a basket soft blanket detailed fur highly realistic',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'a6828dc9-c4b2-4d1e-a10e-6ed5dc5d864a',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            // Insert metadata for archives (replace paths and options as needed)
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\95b2fa67c357772b9883f9cd1a7c0935.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\95b2fa67c357772b9883f9cd1a7c0935.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\95b2fa67c357772b9883f9cd1a7c0935.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '95b2fa67c357772b9883f9cd1a7c0935.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'group-of-three-playful-kittens-cuddling-together-in-a-basket-soft-blanket-detailed-fur-highly-realistic',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
            ]);

        }

        $image24 = DB::table('archives')->where('unique_identifier', 'c5df6122-39f0-485d-acba-4bbe00f08909')->first();

        if (! $image24) {
            // 1) Main archive (id = 152)
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id'        => null,
                'user_id'          => 1,
                'title'            => 'A surreal portrait of a young woman wearing a futuristic astronaut helmet The helmet has a large transparent glass dome and inside it grows a small magical garden with colorful flowers and plants Soft natural light shines through the glass creating reflections and a dreamy atmosphere The girls face is calm and mysterious blending science fiction and nature Ultra realistic highly detailed cinematic photography style',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'c5df6122-39f0-485d-acba-4bbe00f08909',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image',
                'status'           => 'Active',
            ]);

            // 2) User reply archive (id = 153)
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => 1,
                'title'            => 'A surreal portrait of a young woman wearing a futuristic astronaut helmet The helmet has a large transparent glass dome and inside it grows a small magical garden with colorful flowers and plants Soft natural light shines through the glass creating reflections and a dreamy atmosphere The girls face is calm and mysterious blending science fiction and nature Ultra realistic highly detailed cinematic photography style',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'eab3f228-60c6-4a36-bdd8-53f8c136706e',
                'provider'         => null,
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            // 3) AI response archive (id = 154)
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId1,
                'user_id'          => null,
                'title'            => 'A surreal portrait of a young woman wearing a futuristic astronaut helmet The helmet has a large transparent glass dome and inside it grows a small magical garden with colorful flowers and plants Soft natural light shines through the glass creating reflections and a dreamy atmosphere The girls face is calm and mysterious blending science fiction and nature Ultra realistic highly detailed cinematic photography style',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> '58f3df7f-fa41-4fd4-a623-92dd1a92dd6c',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_chat',
                'status'           => 'Active',
            ]);

            // 4) Variant archive (id = 155)
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id'        => $archiveId3,
                'user_id'          => null,
                'title'            => 'A surreal portrait of a young woman wearing a futuristic astronaut helmet The helmet has a large transparent glass dome and inside it grows a small magical garden with colorful flowers and plants Soft natural light shines through the glass creating reflections and a dreamy atmosphere The girls face is calm and mysterious blending science fiction and nature Ultra realistic highly detailed cinematic photography style',
                'content'          => null,
                'filtered_content' => null,
                'raw_response'     => null,
                'unique_identifier'=> 'b6d271e1-b501-4ff8-8597-f43a58a72c67',
                'provider'         => 'clipdrop',
                'expense'          => null,
                'expense_type'     => null,
                'type'             => 'image_variant',
                'status'           => 'Active',
            ]);

            // Metadata for archives
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId1,
                    'type'       => 'array',
                    'key'        => 'images',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\1699262a2e01023e71db01730aad796c.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId3,
                    'type'       => 'array',
                    'key'        => 'images_urls',
                    'value'      => '["public\\\\uploads\\\\aiImages\\\\1699262a2e01023e71db01730aad796c.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'url',
                    'value'      => 'public\\uploads\\aiImages\\1699262a2e01023e71db01730aad796c.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'original_name',
                    'value'      => '1699262a2e01023e71db01730aad796c.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'string',
                    'key'        => 'slug',
                    'value'      => 'a-surreal-portrait-of-a-young-woman-wearing-a-futuristic-astronaut-helmet-the-helmet-has-a-large-transparent-glass-dome1756808364',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id'   => $archiveId4,
                    'type'       => 'integer',
                    'key'        => 'image_creator_id',
                    'value'      => 1,
                ],
            ]);

        }

        $image25 = DB::table('archives')->where('unique_identifier', '9c1640e9-fdfe-41e3-a7e5-6db8a0a2d9e7')->first();

        if (! $image25) {
            // Main Archive
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'Captain America holding his shield on a battlefield torn uniform cinematic lighting realistic textures photorealistic',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '9c1640e9-fdfe-41e3-a7e5-6db8a0a2d9e7',
                'provider' => null,
                'type' => 'image',
                'status' => 'Active',
            ]);

            // User reply archive
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId1,
                'user_id' => 1,
                'title' => 'Captain America holding his shield on a battlefield torn uniform cinematic lighting realistic textures photorealistic',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '98ccde0d-9ea7-40b0-b474-d227d7e6d28f',
                'provider' => null,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI archive
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId1,
                'user_id' => null,
                'title' => 'Captain America holding his shield on a battlefield torn uniform cinematic lighting realistic textures photorealistic',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'b8c17510-bfaf-4caf-b084-87f804db6b8e',
                'provider' => 'stabilityai',
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // Variant archive
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId3,
                'user_id' => null,
                'title' => 'Captain America holding his shield on a battlefield torn uniform cinematic lighting realistic textures photorealistic',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'a2a3d980-ed62-479a-9518-1de75efcb4fa',
                'provider' => 'stabilityai',
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            // Metadata
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId1,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => '["public\\\\uploads\\\\aiImages\\\\7a63bc14586b46b24eab400987971dbc.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId1,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1152x896","art_style":"3D Model","light_effect":"Normal"}',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'string',
                    'key' => 'user_reply',
                    'value' => 'Captain America holding his shield on a battlefield torn uniform cinematic lighting realistic textures photorealistic',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId3,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => '["public\\\\uploads\\\\aiImages\\\\7a63bc14586b46b24eab400987971dbc.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId3,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1152x896","art_style":"3D Model","light_effect":"Normal"}',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\7a63bc14586b46b24eab400987971dbc.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => '7a63bc14586b46b24eab400987971dbc.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'captain-america-holding-his-shield-on-a-battlefield-torn-uniform-cinematic-lighting-realistic-textures-photorealistic',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"stable-diffusion-xl-1024-v1-0","variant":"1","size":"1152x896","art_style":"3D Model","light_effect":"Normal"}',
                ],
            ]);

        }

        $image26 = DB::table('archives')->where('unique_identifier', '55fd5186-54e0-4ef4-864e-d844acda36e7')->first();

        if (! $image26) {
            // Main Archive
            $archiveId1 = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'Ultrarealistic portrait of SpiderMan perched on a rainsoaked skyscraper at night glowing neon city lights reflecting on his red and blue suit raindrops visible on the fabric intricate web patterns on costume cinematic lighting highlighting contours of his muscles dramatic motion as he swings a web mist and fog in the background photorealistic textures ultrahigh detail 8k resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '55fd5186-54e0-4ef4-864e-d844acda36e7',
                'provider' => null,
                'type' => 'image',
                'status' => 'Active',
            ]);

            // User reply archive
            $archiveId2 = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId1,
                'user_id' => 1,
                'title' => 'Ultrarealistic portrait of SpiderMan perched on a rainsoaked skyscraper at night glowing neon city lights reflecting on his red and blue suit raindrops visible on the fabric intricate web patterns on costume cinematic lighting highlighting contours of his muscles dramatic motion as he swings a web mist and fog in the background photorealistic textures ultrahigh detail 8k resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '0a941e39-41f8-41f2-abe7-8ca6a4104bd9',
                'provider' => null,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI archive
            $archiveId3 = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId1,
                'user_id' => null,
                'title' => 'Ultrarealistic portrait of SpiderMan perched on a rainsoaked skyscraper at night glowing neon city lights reflecting on his red and blue suit raindrops visible on the fabric intricate web patterns on costume cinematic lighting highlighting contours of his muscles dramatic motion as he swings a web mist and fog in the background photorealistic textures ultrahigh detail 8k resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '8e26d506-9c49-4164-a067-4fd5aebb6d6a',
                'provider' => 'stabilityai',
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // Variant archive
            $archiveId4 = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId3,
                'user_id' => null,
                'title' => 'Ultrarealistic portrait of SpiderMan perched on a rainsoaked skyscraper at night glowing neon city lights reflecting on his red and blue suit raindrops visible on the fabric intricate web patterns on costume cinematic lighting highlighting contours of his muscles dramatic motion as he swings a web mist and fog in the background photorealistic textures ultrahigh detail 8k resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '87eac713-c2c9-4f31-96af-b01dce34a96a',
                'provider' => 'stabilityai',
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            // Metadata
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId1,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => '["public\\\\uploads\\\\aiImages\\\\8974f4916dd86b1ab9468c5b70ac22b5.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId1,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"sd3.5-large-turbo","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId2,
                    'type' => 'string',
                    'key' => 'user_reply',
                    'value' => 'Ultrarealistic portrait of SpiderMan perched on a rainsoaked skyscraper at night glowing neon city lights reflecting on his red and blue suit raindrops visible on the fabric intricate web patterns on costume cinematic lighting highlighting contours of his muscles dramatic motion as he swings a web mist and fog in the background photorealistic textures ultrahigh detail 8k resolution',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId3,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => '["public\\\\uploads\\\\aiImages\\\\8974f4916dd86b1ab9468c5b70ac22b5.png"]',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId3,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"sd3.5-large-turbo","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\8974f4916dd86b1ab9468c5b70ac22b5.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => '8974f4916dd86b1ab9468c5b70ac22b5.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'ultrarealistic-portrait-of-spiderman-perched-on-a-rainsoaked-skyscraper-at-night-glowing-neon-city-lights-reflecting-on',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId4,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => '{"service":"text-to-image","model":"sd3.5-large-turbo","variant":"1","art_style":"3D Model","light_effect":"Normal","aspect_ratio":"16:9"}',
                ],
            ]);

        }

        
        $image27 = DB::table('archives')->where('unique_identifier', '32dc056c-3951-4811-9ee4-6191565180d2')->first();

        if (! $image27) {
            // Main archive
            $archiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'Ultrarealistic closeup of a fluffy gray tabby cat sitting on a sunlit windowsill sunlight streaming through the window highlighting each strand of fur sharp green eyes reflecting the outside garden fine whiskers visible soft shadows on the face photorealistic textures on fur and eyes cozy indoor atmosphere highly detailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '32dc056c-3951-4811-9ee4-6191565180d2',
                'provider' => null,
                'type' => 'image',
                'status' => 'Active',
            ]);

            // User reply archive
            $archiveChatId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => 1,
                'title' => 'Ultrarealistic closeup of a fluffy gray tabby cat sitting on a sunlit windowsill sunlight streaming through the window highlighting each strand of fur sharp green eyes reflecting the outside garden fine whiskers visible soft shadows on the face photorealistic textures on fur and eyes cozy indoor atmosphere highly detailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '8611ea68-0591-4996-abda-3c85624e7aaf',
                'provider' => null,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI generated image archive
            $archiveAiId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => null,
                'title' => 'Ultrarealistic closeup of a fluffy gray tabby cat sitting on a sunlit windowsill sunlight streaming through the window highlighting each strand of fur sharp green eyes reflecting the outside garden fine whiskers visible soft shadows on the face photorealistic textures on fur and eyes cozy indoor atmosphere highly detailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '3e8f8653-a713-4a64-ada8-65c3a9e92610',
                'provider' => 'stabilityai',
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $archiveVariantId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveAiId,
                'user_id' => null,
                'title' => 'Ultrarealistic closeup of a fluffy gray tabby cat sitting on a sunlit windowsill sunlight streaming through the window highlighting each strand of fur sharp green eyes reflecting the outside garden fine whiskers visible soft shadows on the face photorealistic textures on fur and eyes cozy indoor atmosphere highly detailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '5bf22e43-6284-4c1d-a205-abc6a724e619',
                'provider' => 'stabilityai',
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            // Metadata for main image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\493c5a5a1bde164ceff15d39e8e86d0b.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-large',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '1:1'
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                'owner_id' => $archiveChatId,
                'type' => 'string',
                'key' => 'user_reply',
                'value' => 'Ultrarealistic closeup of a fluffy gray tabby cat sitting on a sunlit windowsill sunlight streaming through the window highlighting each strand of fur sharp green eyes reflecting the outside garden fine whiskers visible soft shadows on the face photorealistic textures on fur and eyes cozy indoor atmosphere highly detailed',
            ]);

            // Metadata for AI image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\493c5a5a1bde164ceff15d39e8e86d0b.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-large',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '1:1'
                    ]),
                ],
            ]);

            // Metadata for AI variant
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\493c5a5a1bde164ceff15d39e8e86d0b.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => '493c5a5a1bde164ceff15d39e8e86d0b.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'ultrarealistic-closeup-of-a-fluffy-gray-tabby-cat-sitting-on-a-sunlit-windowsill-sunlight-streaming-through-the-window-h',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-large',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '1:1'
                    ]),
                ],
            ]);

        }

        $image28 = DB::table('archives')->where('unique_identifier', '05935d57-1c81-479e-8c6d-76e7f77b3c62')->first();

        if (! $image28) {
            // Main archive
            $archiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'Ultrarealistic depiction of a small yellow creature resembling a Pikachu sitting on a grassy field soft sunlight illuminating its fur detailed textures showing tiny hairs expressive round eyes reflecting the sky slightly rosy cheeks realistic proportions natural shadows photorealistic ultradetailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '05935d57-1c81-479e-8c6d-76e7f77b3c62',
                'provider' => null,
                'type' => 'image',
                'status' => 'Active',
            ]);

            // User reply archive
            $archiveChatId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => 1,
                'title' => 'Ultrarealistic depiction of a small yellow creature resembling a Pikachu sitting on a grassy field soft sunlight illuminating its fur detailed textures showing tiny hairs expressive round eyes reflecting the sky slightly rosy cheeks realistic proportions natural shadows photorealistic ultradetailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '584c1d4a-d92a-4f66-8043-b9282d07bd3e',
                'provider' => null,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI generated image archive
            $archiveAiId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => null,
                'title' => 'Ultrarealistic depiction of a small yellow creature resembling a Pikachu sitting on a grassy field soft sunlight illuminating its fur detailed textures showing tiny hairs expressive round eyes reflecting the sky slightly rosy cheeks realistic proportions natural shadows photorealistic ultradetailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'f6455ac9-93d4-4d23-8481-ac90f6f708b1',
                'provider' => 'stabilityai',
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $archiveVariantId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveAiId,
                'user_id' => null,
                'title' => 'Ultrarealistic depiction of a small yellow creature resembling a Pikachu sitting on a grassy field soft sunlight illuminating its fur detailed textures showing tiny hairs expressive round eyes reflecting the sky slightly rosy cheeks realistic proportions natural shadows photorealistic ultradetailed',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'd351f737-c16b-4a84-9792-796355b7b297',
                'provider' => 'stabilityai',
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            // Metadata for main image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\2c90ece51126bd02c35a0457a32502f3.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-large',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '4:5'
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                'owner_id' => $archiveChatId,
                'type' => 'string',
                'key' => 'user_reply',
                'value' => 'Ultrarealistic depiction of a small yellow creature resembling a Pikachu sitting on a grassy field soft sunlight illuminating its fur detailed textures showing tiny hairs expressive round eyes reflecting the sky slightly rosy cheeks realistic proportions natural shadows photorealistic ultradetailed',
            ]);

            // Metadata for AI image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\2c90ece51126bd02c35a0457a32502f3.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-large',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '4:5'
                    ]),
                ],
            ]);

            // Metadata for AI variant
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\2c90ece51126bd02c35a0457a32502f3.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => '2c90ece51126bd02c35a0457a32502f3.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'ultrarealistic-depiction-of-a-small-yellow-creature-resembling-a-pikachu-sitting-on-a-grassy-field-soft-sunlight-illumin',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-large',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '4:5'
                    ]),
                ],
            ]);

        }

        $image29 = DB::table('archives')->where('unique_identifier', '7524a6c0-8f68-4176-bdae-35c89cdbbc8c')->first();

        if (! $image29) {
            // Main archive
            $archiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'Aerial view of a modern city at sunset skyscrapers with glass facades reflecting the warm orange and pink hues of the sky soft sunlight illuminating the tops of buildings streets below filled with tiny cars and pedestrians subtle shadows stretching across roads realistic reflections in windows clouds tinged with gold and purple cinematic composition with depth and perspective photorealistic textures on buildings and streets ultradetailed high resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '7524a6c0-8f68-4176-bdae-35c89cdbbc8c',
                'provider' => null,
                'type' => 'image',
                'status' => 'Active',
            ]);

            // User reply archive
            $archiveChatId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => 1,
                'title' => 'Aerial view of a modern city at sunset skyscrapers with glass facades reflecting the warm orange and pink hues of the sky soft sunlight illuminating the tops of buildings streets below filled with tiny cars and pedestrians subtle shadows stretching across roads realistic reflections in windows clouds tinged with gold and purple cinematic composition with depth and perspective photorealistic textures on buildings and streets ultradetailed high resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '1bccb8bb-1133-4b35-ba02-acf1f82997f2',
                'provider' => null,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI generated image archive
            $archiveAiId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => null,
                'title' => 'Aerial view of a modern city at sunset skyscrapers with glass facades reflecting the warm orange and pink hues of the sky soft sunlight illuminating the tops of buildings streets below filled with tiny cars and pedestrians subtle shadows stretching across roads realistic reflections in windows clouds tinged with gold and purple cinematic composition with depth and perspective photorealistic textures on buildings and streets ultradetailed high resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '9b175bfb-424f-4ee9-b0d2-1e4d574b030e',
                'provider' => 'stabilityai',
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $archiveVariantId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveAiId,
                'user_id' => null,
                'title' => 'Aerial view of a modern city at sunset skyscrapers with glass facades reflecting the warm orange and pink hues of the sky soft sunlight illuminating the tops of buildings streets below filled with tiny cars and pedestrians subtle shadows stretching across roads realistic reflections in windows clouds tinged with gold and purple cinematic composition with depth and perspective photorealistic textures on buildings and streets ultradetailed high resolution',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '3f1e1b60-0cd2-40f2-8e8f-3bb3a08378b7',
                'provider' => 'stabilityai',
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            // Metadata for main image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\e5c9e95abbd039995368459f70c9036b.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-medium',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '1:1'
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                'owner_id' => $archiveChatId,
                'type' => 'string',
                'key' => 'user_reply',
                'value' => 'Aerial view of a modern city at sunset skyscrapers with glass facades reflecting the warm orange and pink hues of the sky soft sunlight illuminating the tops of buildings streets below filled with tiny cars and pedestrians subtle shadows stretching across roads realistic reflections in windows clouds tinged with gold and purple cinematic composition with depth and perspective photorealistic textures on buildings and streets ultradetailed high resolution',
            ]);

            // Metadata for AI image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\e5c9e95abbd039995368459f70c9036b.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-medium',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '1:1'
                    ]),
                ],
            ]);

            // Metadata for AI variant
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\e5c9e95abbd039995368459f70c9036b.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => 'e5c9e95abbd039995368459f70c9036b.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'aerial-view-of-a-modern-city-at-sunset-skyscrapers-with-glass-facades-reflecting-the-warm-orange-and-pink-hues-of-the-sk',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-medium',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '1:1'
                    ]),
                ],
            ]);

        }


        $image30 = DB::table('archives')->where('unique_identifier', 'a674904e-c959-4d9c-8a4b-54cf1ff13be9')->first();

        if (! $image30) {
            // Main archive
            $archiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'A hyperrealistic black panther with a body covered in sparkling black gemstones of uniform size instead of its natural skin shimmering and glowing confidently walking on a glossy runway at a glamorous fashion show intricate gemstone patterns detailed skin texture high fashion style glamorous lighting 8k resolution photorealistic cinematic lighting',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'a674904e-c959-4d9c-8a4b-54cf1ff13be9',
                'provider' => null,
                'type' => 'image',
                'status' => 'Active',
            ]);

            // User reply archive
            $archiveChatId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => 1,
                'title' => 'A hyperrealistic black panther with a body covered in sparkling black gemstones of uniform size instead of its natural skin shimmering and glowing confidently walking on a glossy runway at a glamorous fashion show intricate gemstone patterns detailed skin texture high fashion style glamorous lighting 8k resolution photorealistic cinematic lighting',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'b61219f7-dd1d-416a-9d55-861071a0a2f9',
                'provider' => null,
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI generated image archive
            $archiveAiId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveId,
                'user_id' => null,
                'title' => 'A hyperrealistic black panther with a body covered in sparkling black gemstones of uniform size instead of its natural skin shimmering and glowing confidently walking on a glossy runway at a glamorous fashion show intricate gemstone patterns detailed skin texture high fashion style glamorous lighting 8k resolution photorealistic cinematic lighting',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '32e05be9-4f39-43b9-9cf8-4eddb5bac567',
                'provider' => 'stabilityai',
                'type' => 'image_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $archiveVariantId = DB::table('archives')->insertGetId([
                'parent_id' => $archiveAiId,
                'user_id' => null,
                'title' => 'A hyperrealistic black panther with a body covered in sparkling black gemstones of uniform size instead of its natural skin shimmering and glowing confidently walking on a glossy runway at a glamorous fashion show intricate gemstone patterns detailed skin texture high fashion style glamorous lighting 8k resolution photorealistic cinematic lighting',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '07c899ac-fbed-4662-a079-338a3ae66056',
                'provider' => 'stabilityai',
                'type' => 'image_variant',
                'status' => 'Active',
            ]);

            // Metadata for main image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\3dfead7bb60dbec5ba5892c4b9f44e93.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-medium',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '16:9'
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                'owner_id' => $archiveChatId,
                'type' => 'string',
                'key' => 'user_reply',
                'value' => 'A hyperrealistic black panther with a body covered in sparkling black gemstones of uniform size instead of its natural skin shimmering and glowing confidently walking on a glossy runway at a glamorous fashion show intricate gemstone patterns detailed skin texture high fashion style glamorous lighting 8k resolution photorealistic cinematic lighting',
            ]);

            // Metadata for AI image
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\3dfead7bb60dbec5ba5892c4b9f44e93.png']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveAiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-medium',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '16:9'
                    ]),
                ],
            ]);

            // Metadata for AI variant
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\3dfead7bb60dbec5ba5892c4b9f44e93.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => '3dfead7bb60dbec5ba5892c4b9f44e93.png',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'a-hyperrealistic-black-panther-with-a-body-covered-in-sparkling-black-gemstones-of-uniform-size-instead-of-its-natural-s',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $archiveVariantId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'service' => 'text-to-image',
                        'model' => 'sd3.5-medium',
                        'variant' => '1',
                        'art_style' => '3D Model',
                        'light_effect' => 'Normal',
                        'aspect_ratio' => '16:9'
                    ]),
                ],
            ]);

        }


        $image31 = DB::table('archives')->where('unique_identifier', '3209cf81-fcc6-48bd-bef3-d24eb3116c82')->first();

        if (! $image31) {
            // Main productshot archive
            $productArchiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'bottole_1',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '3209cf81-fcc6-48bd-bef3-d24eb3116c82',
                'provider' => null,
                'type' => 'productshot',
                'status' => 'Active',
            ]);

            // User reply archive
            $productChatId = DB::table('archives')->insertGetId([
                'parent_id' => $productArchiveId,
                'user_id' => 1,
                'title' => 'bottole_1',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'fd8d6ce2-7adb-490f-ad57-8a526450d892',
                'provider' => null,
                'type' => 'productshot_chat',
                'status' => 'Active',
            ]);

            // AI generated productshot archive
            $productAiId = DB::table('archives')->insertGetId([
                'parent_id' => $productArchiveId,
                'user_id' => null,
                'title' => 'bottole_1',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '756782fc-74cc-46d2-b5ac-fd777ddc6ca2',
                'provider' => 'pebblely',
                'type' => 'productshot_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $productVariantId = DB::table('archives')->insertGetId([
                'parent_id' => $productAiId,
                'user_id' => null,
                'title' => 'bottole_1',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '3f19f138-063f-4579-b414-b3f4d3a97ef7',
                'provider' => 'pebblely',
                'type' => 'productshot_variant',
                'status' => 'Active',
            ]);

            // Metadata for main productshot
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $productArchiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\468f20106e39131094d8bee8bab5e754.jpeg']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $productArchiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '512x512',
                        'description' => null,
                        'negative_prompt' => null,
                        'background_id' => 'furniture',
                        'file' => new stdClass(),
                        'original_background' => 'Furniture'
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $productChatId,
                    'type' => 'string',
                    'key' => 'user_reply',
                    'value' => 'bottole_1',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $productChatId,
                    'type' => 'string',
                    'key' => 'uploaded_file_name',
                    'value' => 'public\\uploads\\aiProductshot\\20250902\\592729f7accc909c4f17f281a8c53505.png',
                ],
            ]);

            // Metadata for AI generated productshot
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $productAiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\468f20106e39131094d8bee8bab5e754.jpeg']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $productAiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '512x512',
                        'description' => null,
                        'negative_prompt' => null,
                        'background_id' => 'furniture',
                        'file' => new stdClass(),
                        'original_background' => 'Furniture'
                    ]),
                ],
            ]); 

        }

        $image32 = DB::table('archives')->where('unique_identifier', 'b8209297-d333-40b9-909c-388488b2220d')->first();

        if (! $image32) {
            // Main productshot archive
            $foodArchiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'food',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'b8209297-d333-40b9-909c-388488b2220d',
                'provider' => null,
                'type' => 'productshot',
                'status' => 'Active',
            ]);

            // User reply archive
            $foodChatId = DB::table('archives')->insertGetId([
                'parent_id' => $foodArchiveId,
                'user_id' => 1,
                'title' => 'food',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'bf483f24-cecf-4ff2-9ef6-0783f1c465fd',
                'provider' => null,
                'type' => 'productshot_chat',
                'status' => 'Active',
            ]);

            // AI generated productshot archive
            $foodAiId = DB::table('archives')->insertGetId([
                'parent_id' => $foodArchiveId,
                'user_id' => null,
                'title' => 'food',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '21dafe00-55c5-40c0-8dd6-4c1642d5944c',
                'provider' => 'pebblely',
                'type' => 'productshot_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $foodVariantId = DB::table('archives')->insertGetId([
                'parent_id' => $foodAiId,
                'user_id' => null,
                'title' => 'food',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '240ae450-eb90-4d61-8e95-a879bb3935c4',
                'provider' => 'pebblely',
                'type' => 'productshot_variant',
                'status' => 'Active',
            ]);

            // Metadata for main productshot
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodArchiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\2c15094c843195956247009844eb37da.jpeg']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodArchiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '2048x2048',
                        'description' => 'A modern kitchen with a wooden countertop, soft natural light streaming through a nearby window. Steam rises gently from a freshly cooked burger placed on a plate in the center. Fresh ingredients like lettuce, tomato, and cheese scattered around, condiments and utensils nearby. Clean, minimalist kitchen appliances in the background, subtle reflections on surfaces, photorealistic textures, ultra-detailed, cinematic lighting',
                        'negative_prompt' => null,
                        'file' => new stdClass(),
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodChatId,
                    'type' => 'string',
                    'key' => 'user_reply',
                    'value' => 'food',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodChatId,
                    'type' => 'string',
                    'key' => 'uploaded_file_name',
                    'value' => 'public\\uploads\\aiProductshot\\20250902\\357b2b1f0cd7f6e259aac345b50ad068.webp',
                ],
            ]);

            // Metadata for AI generated productshot
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodAiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\2c15094c843195956247009844eb37da.jpeg']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodAiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '2048x2048',
                        'description' => 'A modern kitchen with a wooden countertop, soft natural light streaming through a nearby window. Steam rises gently from a freshly cooked burger placed on a plate in the center. Fresh ingredients like lettuce, tomato, and cheese scattered around, condiments and utensils nearby. Clean, minimalist kitchen appliances in the background, subtle reflections on surfaces, photorealistic textures, ultra-detailed, cinematic lighting',
                        'negative_prompt' => null,
                        'file' => new stdClass(),
                    ]),
                ],
            ]);

            // Metadata for AI variant
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodVariantId,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\2c15094c843195956247009844eb37da.jpeg',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodVariantId,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => '2c15094c843195956247009844eb37da.jpeg',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodVariantId,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'food1756811518',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodVariantId,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $foodVariantId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '2048x2048',
                        'description' => 'A modern kitchen with a wooden countertop, soft natural light streaming through a nearby window. Steam rises gently from a freshly cooked burger placed on a plate in the center. Fresh ingredients like lettuce, tomato, and cheese scattered around, condiments and utensils nearby. Clean, minimalist kitchen appliances in the background, subtle reflections on surfaces, photorealistic textures, ultra-detailed, cinematic lighting',
                        'negative_prompt' => null,
                        'file' => new stdClass(),
                    ]),
                ],
            ]);

        }

        $image33 = DB::table('archives')->where('unique_identifier', '2b6b6ee7-0cf7-486c-bd3d-db8486465d57')->first();

        if (! $image33) {
            // Main productshot archive
            $show2ArchiveId = DB::table('archives')->insertGetId([
                'parent_id' => null,
                'user_id' => 1,
                'title' => 'show_2',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '2b6b6ee7-0cf7-486c-bd3d-db8486465d57',
                'provider' => null,
                'type' => 'productshot',
                'status' => 'Active',
            ]);

            // User reply archive
            $show2ChatId = DB::table('archives')->insertGetId([
                'parent_id' => $show2ArchiveId,
                'user_id' => 1,
                'title' => 'show_2',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '91c50b7c-9d04-44e4-a9a5-bf00771c455d',
                'provider' => null,
                'type' => 'productshot_chat',
                'status' => 'Active',
            ]);

            // AI generated productshot archive
            $show2AiId = DB::table('archives')->insertGetId([
                'parent_id' => $show2ArchiveId,
                'user_id' => null,
                'title' => 'show_2',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => 'b111a49a-c754-4acc-8a78-b3e752874856',
                'provider' => 'pebblely',
                'type' => 'productshot_chat',
                'status' => 'Active',
            ]);

            // AI variant archive
            $show2VariantId = DB::table('archives')->insertGetId([
                'parent_id' => $show2AiId,
                'user_id' => null,
                'title' => 'show_2',
                'content' => null,
                'filtered_content' => null,
                'raw_response' => null,
                'unique_identifier' => '35827886-80e7-478a-950b-ab8442c53eed',
                'provider' => 'pebblely',
                'type' => 'productshot_variant',
                'status' => 'Active',
            ]);

            // Metadata for main productshot
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2ArchiveId,
                    'type' => 'array',
                    'key' => 'images',
                    'value' => json_encode(['public\\uploads\\aiImages\\f3913f08226c782d6bdb77afc90ac8a0.jpeg']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2ArchiveId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '2048x2048',
                        'description' => null,
                        'negative_prompt' => null,
                        'background_id' => 'dark-wood',
                        'file' => new stdClass(),
                        'original_background' => 'Dark Wood',
                    ]),
                ],
            ]);

            // Metadata for user reply
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2ChatId,
                    'type' => 'string',
                    'key' => 'user_reply',
                    'value' => 'show_2',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2ChatId,
                    'type' => 'string',
                    'key' => 'uploaded_file_name',
                    'value' => 'public\\uploads\\aiProductshot\\20250902\\f58084a62c2787908d807f9467bfb2c5.png',
                ],
            ]);

            // Metadata for AI generated productshot
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2AiId,
                    'type' => 'array',
                    'key' => 'images_urls',
                    'value' => json_encode(['public\\uploads\\aiImages\\f3913f08226c782d6bdb77afc90ac8a0.jpeg']),
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2AiId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '2048x2048',
                        'description' => null,
                        'negative_prompt' => null,
                        'background_id' => 'dark-wood',
                        'file' => new stdClass(),
                        'original_background' => 'Dark Wood',
                    ]),
                ],
            ]);

            // Metadata for AI variant
            DB::table('archives_meta')->insert([
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2VariantId,
                    'type' => 'string',
                    'key' => 'url',
                    'value' => 'public\\uploads\\aiImages\\f3913f08226c782d6bdb77afc90ac8a0.jpeg',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2VariantId,
                    'type' => 'string',
                    'key' => 'original_name',
                    'value' => 'f3913f08226c782d6bdb77afc90ac8a0.jpeg',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2VariantId,
                    'type' => 'string',
                    'key' => 'slug',
                    'value' => 'show_2',
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2VariantId,
                    'type' => 'integer',
                    'key' => 'image_creator_id',
                    'value' => 1,
                ],
                [
                    'owner_type' => 'Modules\\OpenAI\\Entities\\Archive',
                    'owner_id' => $show2VariantId,
                    'type' => 'array',
                    'key' => 'generation_options',
                    'value' => json_encode([
                        'model' => 'default',
                        'service' => 'create-background',
                        'size' => '2048x2048',
                        'description' => null,
                        'negative_prompt' => null,
                        'background_id' => 'dark-wood',
                        'file' => new stdClass(),
                        'original_background' => 'Dark Wood',
                    ]),
                ],
            ]);

        }


    }
}