<?php

namespace Modules\Dummy\Database\Seeders\Modules\Subscription;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

use Modules\Dummy\Database\Seeders\Modules\Subscription\versions\v1_2_0\DatabaseSeeder as DatabaseSeederV12;

use Modules\Dummy\Database\Seeders\Modules\Subscription\versions\v1_4_0\DatabaseSeeder as DatabaseSeederV14;

use Modules\Dummy\Database\Seeders\Modules\Subscription\versions\v2_6_0\DatabaseSeeder as DatabaseSeederV26;

use Modules\Dummy\Database\Seeders\Modules\Subscription\versions\v2_7_0\DatabaseSeeder as DatabaseSeederV27;

use Modules\Dummy\Database\Seeders\Modules\Subscription\versions\v3_2_0\DatabaseSeeder as DatabaseSeederV32;

use Modules\Dummy\Database\Seeders\Modules\Subscription\versions\v4_0_0\DatabaseSeeder as DatabaseSeederV40;

class SubscriptionDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $this->call(AdminMenusTableSeeder::class);
        $this->call(MenuItemsTableSeeder::class);

        $this->call(PackagesTableSeeder::class);
        $this->call(PackagesMetaTableSeeder::class);
        $this->call(PackageSubscriptionsTableSeeder::class);
        $this->call(PackageSubscriptionsMetaTableSeeder::class);
        $this->call(SubscriptionDetailsTableSeeder::class);

        $this->call(DatabaseSeederV12::class);
        $this->call(DatabaseSeederV14::class);

        $this->call(DatabaseSeederV26::class);
        $this->call(DatabaseSeederV27::class);
        $this->call(DatabaseSeederV32::class);

        $this->call(DatabaseSeederV40::class);

    }
}
