"use strict";

// Affiliate user profile (frontend)
if ($('.main-body .page-wrapper').find('#affiliate-user-profile-container').length) {
    $(window).on("load", function () {
        $(".referralURL").on("click", copyReferralURL);
    });

    function copyReferralURL() {
        var copyText = $(this).text();

        // Copy the text inside the text field
        navigator.clipboard.writeText(copyText);
        triggerNotification(jsLang('link copied'));
    }

    const triggerNotification = (msg) => {
        $(".notification-msg-bar").find(".notification-msg").html(msg);
        $(".notification-msg-bar").removeClass("smoothly-hide");
        setTimeout(() => {
            $(".notification-msg-bar").addClass("smoothly-hide"),
                $(".notification-msg-bar").find(".notification-msg").html("");
        }, 2500);
    };
}

// Affiliate user profile (admin)
if ($('.main-body .page-wrapper').find('#affiliate-profile-container').length) {
    $("#life_time_customers").select2({
        ajax: {
            url: SITE_URL + '/find-users-with-ajax',
            dataType: "json",
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page,
                };
            },
            processResults: function (data, params) {
                let results = data.data;
                return {
                    results: results
                };
            },
            cache: true,
        },
        placeholder: jsLang("Search for customers."),
        minimumInputLength: 3,
    });

    $(".referral_link").on("click", function () {
        var copyText = $(this).text();
        navigator.clipboard.writeText(copyText);
    });
}
