@extends('affiliate::layouts.app')
@section('page_title', __('Profile'))

@section('content')
    <!-- Main content -->
    <div class="col-sm-12" id="affiliate-user-profile-container">

        <div class="col-md-12 no-print notification-msg-bar smoothly-hide">
            <div class="noti-alert pad">
                <div class="alert bg-dark text-light m-0 text-center">
                    <span class="notification-msg"></span>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body row">
                <div class="col-lg-12 col-12 {{ languageDirection() == 'ltr' ? 'ps-0' : 'pe-0' }}">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-0 border-bottom">
                            <h5>{{ __('Profile') }}</h5>
                        </div>
                        <div class="card-block table-border-style">
                            <form action="#" method="post" class="form-horizontal" id="affiliate_setting_form">
                                @csrf
                                <div class="card-body p-0">
                                    @foreach ($formHeaders as $header)
                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label text-left" for="file_size">{!! ucwords($header['label']) !!}</label>
                                        <div class="col-sm-6 form-group flex-wrap">
                                            <span>{{ $affiliateUser->renderEntryContent($header['name'], $header['type']) }}</span>
                                        </div>
                                    </div>
                                    @endforeach
                                    @if(preference('affiliate_identifier') == 1)
                                        <div class="form-group row">
                                            <label class="col-sm-3 control-label text-left" for="file_size">{{ __('Your affiliate identifier is') }}  </label>
                                            <div class="col-sm-6 form-group flex-wrap">
                                                <input
                                                    class="border-0 bg-white customs-permalink w-100"
                                                    type="text"
                                                    id="identifier"
                                                    value="{{ $affiliateUser->getIdentifier() }}"
                                                    readonly
                                                />
                                            </div>
                                        </div>
                                    @else
                                        <div class="form-group row">
                                            <label class="col-sm-3 control-label text-left" for="file_size">{{ __('Your affiliate identifier is') }}  </label>
                                            <div class="col-sm-6 form-group flex-wrap">
                                                <span>{{ $affiliateUser->getIdentifier() }}</span>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label text-left" for="file_size">{{ __('Your referral URL is') }}  </label>
                                        <div class="col-sm-6 form-group flex-wrap">
                                            <a href="javascript:void(0)" class="referralURL">
                                                {{ url('registration') }}?{{ \Modules\Affiliate\Entities\Referral::getReferenceKey() }}={{ $affiliateUser->getIdentifier() }}
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('Modules/Affiliate/Resources/assets/js/user_profile.js') }}"></script>
@endsection
